/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.i18n.messages.loggers.test;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.knox.gateway.i18n.messages.MessageLogger;
import org.apache.knox.gateway.i18n.messages.MessageLoggerFactory;
import org.apache.knox.gateway.i18n.messages.loggers.test.TestMessageLogger;

public class TestMessageLoggerFactory
implements MessageLoggerFactory {
    private static TestMessageLoggerFactory INSTANCE;
    private static final Map<String, MessageLogger> LOGGERS;

    public static TestMessageLoggerFactory getFactory() {
        if (INSTANCE == null) {
            INSTANCE = new TestMessageLoggerFactory();
        }
        return INSTANCE;
    }

    public TestMessageLoggerFactory() {
        INSTANCE = this;
    }

    @Override
    public MessageLogger getLogger(String name) {
        MessageLogger logger = LOGGERS.get(name);
        if (logger == null) {
            logger = new TestMessageLogger(name);
            LOGGERS.put(name, logger);
        }
        return logger;
    }

    static {
        LOGGERS = new ConcurrentHashMap<String, MessageLogger>();
    }
}

