/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.services.security.impl;

import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.knox.gateway.GatewayMessages;
import org.apache.knox.gateway.GatewayResources;
import org.apache.knox.gateway.config.GatewayConfig;
import org.apache.knox.gateway.i18n.messages.MessagesFactory;
import org.apache.knox.gateway.i18n.resources.ResourcesFactory;
import org.apache.knox.gateway.services.Service;
import org.apache.knox.gateway.services.ServiceLifecycleException;
import org.apache.knox.gateway.services.security.KeystoreService;
import org.apache.knox.gateway.services.security.KeystoreServiceException;
import org.apache.knox.gateway.services.security.impl.BaseKeystoreService;
import org.apache.knox.gateway.services.security.impl.X509CertificateUtil;

public class DefaultKeystoreService
extends BaseKeystoreService
implements KeystoreService,
Service {
    private static final String dnTemplate = "CN={0},OU=Test,O=Hadoop,L=Test,ST=Test,C=US";
    private static final String CREDENTIALS_SUFFIX = "-credentials.jceks";
    public static final String GATEWAY_KEYSTORE = "gateway.jks";
    private static final String CERT_GEN_MODE = "hadoop.gateway.cert.gen.mode";
    private static final String CERT_GEN_MODE_LOCALHOST = "localhost";
    private static final String CERT_GEN_MODE_HOSTNAME = "hostname";
    private static GatewayMessages LOG = (GatewayMessages)MessagesFactory.get(GatewayMessages.class);
    private static GatewayResources RES = (GatewayResources)ResourcesFactory.get(GatewayResources.class);
    private String signingKeystoreName = null;
    private String signingKeyAlias = null;
    private Map<String, Map<String, String>> cache = new ConcurrentHashMap<String, Map<String, String>>();
    private Lock readLock = null;
    private Lock writeLock = null;

    public void init(GatewayConfig config, Map<String, String> options) throws ServiceLifecycleException {
        ReentrantReadWriteLock lock = new ReentrantReadWriteLock(true);
        this.readLock = lock.readLock();
        this.writeLock = lock.writeLock();
        this.keyStoreDir = config.getGatewaySecurityDir() + File.separator + "keystores" + File.separator;
        File ksd = new File(this.keyStoreDir);
        if (!ksd.exists() && !ksd.mkdirs()) {
            throw new ServiceLifecycleException(RES.failedToCreateKeyStoreDirectory(ksd.getAbsolutePath()));
        }
        this.signingKeystoreName = config.getSigningKeystoreName();
        if (this.signingKeystoreName != null) {
            File sks = new File(this.keyStoreDir, this.signingKeystoreName);
            if (!sks.exists()) {
                throw new ServiceLifecycleException("Configured signing keystore does not exist.");
            }
            this.signingKeyAlias = config.getSigningKeyAlias();
            if (this.signingKeyAlias != null) {
                try {
                    KeyStore ks = this.getSigningKeystore();
                    if (ks != null && !ks.containsAlias(this.signingKeyAlias)) {
                        throw new ServiceLifecycleException("Configured signing key alias does not exist.");
                    }
                }
                catch (KeystoreServiceException e) {
                    throw new ServiceLifecycleException("Unable to get the configured signing keystore.", (Exception)((Object)e));
                }
                catch (KeyStoreException e) {
                    throw new ServiceLifecycleException("Signing keystore has not been loaded.", (Exception)e);
                }
            }
        }
    }

    public void start() throws ServiceLifecycleException {
    }

    public void stop() throws ServiceLifecycleException {
    }

    public void createKeystoreForGateway() throws KeystoreServiceException {
        this.writeLock.lock();
        try {
            String filename = this.getKeystorePath();
            this.createKeystore(filename, "JKS");
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public KeyStore getKeystoreForGateway() throws KeystoreServiceException {
        File keyStoreFile = new File(this.keyStoreDir + GATEWAY_KEYSTORE);
        this.readLock.lock();
        try {
            KeyStore keyStore = this.getKeystore(keyStoreFile, "JKS");
            return keyStore;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public KeyStore getSigningKeystore() throws KeystoreServiceException {
        return this.getSigningKeystore(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public KeyStore getSigningKeystore(String keystoreName) throws KeystoreServiceException {
        File keyStoreFile = keystoreName != null ? new File(this.keyStoreDir + keystoreName + ".jks") : (this.signingKeystoreName != null ? new File(this.keyStoreDir + this.signingKeystoreName) : new File(this.keyStoreDir + GATEWAY_KEYSTORE));
        if (!keyStoreFile.exists()) {
            throw new KeystoreServiceException("Configured signing keystore does not exist.");
        }
        this.readLock.lock();
        try {
            KeyStore keyStore = this.getKeystore(keyStoreFile, "JKS");
            return keyStore;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public void addSelfSignedCertForGateway(String alias, char[] passphrase) throws KeystoreServiceException {
        this.writeLock.lock();
        try {
            this.addSelfSignedCertForGateway(alias, passphrase, null);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSelfSignedCertForGateway(String alias, char[] passphrase, String hostname) throws KeystoreServiceException {
        this.writeLock.lock();
        try {
            try {
                String dn;
                KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance("RSA");
                keyPairGenerator.initialize(1024);
                KeyPair KPair = keyPairGenerator.generateKeyPair();
                if (hostname == null) {
                    hostname = System.getProperty(CERT_GEN_MODE, CERT_GEN_MODE_LOCALHOST);
                }
                X509Certificate cert = null;
                if (hostname.equals(CERT_GEN_MODE_HOSTNAME)) {
                    dn = this.buildDistinguishedName(InetAddress.getLocalHost().getHostName());
                    cert = X509CertificateUtil.generateCertificate((String)dn, (KeyPair)KPair, (int)365, (String)"SHA1withRSA");
                } else {
                    dn = this.buildDistinguishedName(hostname);
                    cert = X509CertificateUtil.generateCertificate((String)dn, (KeyPair)KPair, (int)365, (String)"SHA1withRSA");
                }
                KeyStore privateKS = this.getKeystoreForGateway();
                privateKS.setKeyEntry(alias, KPair.getPrivate(), passphrase, new Certificate[]{cert});
                this.writeKeystoreToFile(privateKS, new File(this.keyStoreDir + GATEWAY_KEYSTORE));
            }
            catch (IOException | GeneralSecurityException e) {
                LOG.failedToAddSeflSignedCertForGateway(alias, e);
                throw new KeystoreServiceException(e);
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    private String buildDistinguishedName(String hostname) {
        MessageFormat headerFormatter = new MessageFormat(dnTemplate, Locale.ROOT);
        String[] paramArray = new String[]{hostname};
        String dn = headerFormatter.format(paramArray);
        return dn;
    }

    public void createCredentialStoreForCluster(String clusterName) throws KeystoreServiceException {
        String filename = this.keyStoreDir + clusterName + CREDENTIALS_SUFFIX;
        this.writeLock.lock();
        try {
            this.createKeystore(filename, "JCEKS");
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isCredentialStoreForClusterAvailable(String clusterName) throws KeystoreServiceException {
        boolean rc = false;
        File keyStoreFile = new File(this.keyStoreDir + clusterName + CREDENTIALS_SUFFIX);
        this.readLock.lock();
        try {
            try {
                rc = this.isKeystoreAvailable(keyStoreFile, "JCEKS");
            }
            catch (KeyStoreException e) {
                throw new KeystoreServiceException((Exception)e);
            }
            catch (IOException e) {
                throw new KeystoreServiceException((Exception)e);
            }
            boolean bl = rc;
            return bl;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isKeystoreForGatewayAvailable() throws KeystoreServiceException {
        boolean rc = false;
        File keyStoreFile = new File(this.keyStoreDir + GATEWAY_KEYSTORE);
        this.readLock.lock();
        try {
            try {
                rc = this.isKeystoreAvailable(keyStoreFile, "JKS");
            }
            catch (KeyStoreException e) {
                throw new KeystoreServiceException((Exception)e);
            }
            catch (IOException e) {
                throw new KeystoreServiceException((Exception)e);
            }
            boolean bl = rc;
            return bl;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Key getKeyForGateway(String alias, char[] passphrase) throws KeystoreServiceException {
        Key key = null;
        this.readLock.lock();
        try {
            KeyStore ks = this.getKeystoreForGateway();
            if (passphrase == null) {
                passphrase = this.masterService.getMasterSecret();
                LOG.assumingKeyPassphraseIsMaster();
            }
            if (ks != null) {
                try {
                    key = ks.getKey(alias, passphrase);
                }
                catch (UnrecoverableKeyException e) {
                    LOG.failedToGetKeyForGateway(alias, e);
                }
                catch (KeyStoreException e) {
                    LOG.failedToGetKeyForGateway(alias, e);
                }
                catch (NoSuchAlgorithmException e) {
                    LOG.failedToGetKeyForGateway(alias, e);
                }
            }
            Key key2 = key;
            return key2;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public Key getSigningKey(String alias, char[] passphrase) throws KeystoreServiceException {
        return this.getSigningKey(null, alias, passphrase);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Key getSigningKey(String keystoreName, String alias, char[] passphrase) throws KeystoreServiceException {
        Key key = null;
        this.readLock.lock();
        try {
            KeyStore ks = this.getSigningKeystore(keystoreName);
            if (passphrase == null) {
                passphrase = this.masterService.getMasterSecret();
                LOG.assumingKeyPassphraseIsMaster();
            }
            if (ks != null) {
                try {
                    key = ks.getKey(alias, passphrase);
                }
                catch (UnrecoverableKeyException e) {
                    LOG.failedToGetKeyForGateway(alias, e);
                }
                catch (KeyStoreException e) {
                    LOG.failedToGetKeyForGateway(alias, e);
                }
                catch (NoSuchAlgorithmException e) {
                    LOG.failedToGetKeyForGateway(alias, e);
                }
            }
            Key key2 = key;
            return key2;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public KeyStore getCredentialStoreForCluster(String clusterName) throws KeystoreServiceException {
        File keyStoreFile = new File(this.keyStoreDir + clusterName + CREDENTIALS_SUFFIX);
        this.readLock.lock();
        try {
            KeyStore keyStore = this.getKeystore(keyStoreFile, "JCEKS");
            return keyStore;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addCredentialForCluster(String clusterName, String alias, String value) throws KeystoreServiceException {
        this.writeLock.lock();
        try {
            this.removeFromCache(clusterName, alias);
            KeyStore ks = this.getCredentialStoreForCluster(clusterName);
            this.addCredential(alias, value, ks);
            File keyStoreFile = new File(this.keyStoreDir + clusterName + CREDENTIALS_SUFFIX);
            try {
                this.writeKeystoreToFile(ks, keyStoreFile);
            }
            catch (KeyStoreException e) {
                LOG.failedToAddCredentialForCluster(clusterName, e);
            }
            catch (NoSuchAlgorithmException e) {
                LOG.failedToAddCredentialForCluster(clusterName, e);
            }
            catch (CertificateException e) {
                LOG.failedToAddCredentialForCluster(clusterName, e);
            }
            catch (IOException e) {
                LOG.failedToAddCredentialForCluster(clusterName, e);
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public char[] getCredentialForCluster(String clusterName, String alias) throws KeystoreServiceException {
        char[] credential = null;
        this.readLock.lock();
        try {
            KeyStore ks;
            credential = this.checkCache(clusterName, alias);
            if (credential == null && (ks = this.getCredentialStoreForCluster(clusterName)) != null) {
                try {
                    char[] masterSecret = this.masterService.getMasterSecret();
                    Key credentialKey = ks.getKey(alias, masterSecret);
                    if (credentialKey != null) {
                        byte[] credentialBytes = credentialKey.getEncoded();
                        String credentialString = new String(credentialBytes, StandardCharsets.UTF_8);
                        credential = credentialString.toCharArray();
                        this.addToCache(clusterName, alias, credentialString);
                    }
                }
                catch (UnrecoverableKeyException e) {
                    LOG.failedToGetCredentialForCluster(clusterName, e);
                }
                catch (KeyStoreException e) {
                    LOG.failedToGetCredentialForCluster(clusterName, e);
                }
                catch (NoSuchAlgorithmException e) {
                    LOG.failedToGetCredentialForCluster(clusterName, e);
                }
            }
            char[] cArray = credential;
            return cArray;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeCredentialForCluster(String clusterName, String alias) throws KeystoreServiceException {
        File keyStoreFile = new File(this.keyStoreDir + clusterName + CREDENTIALS_SUFFIX);
        this.writeLock.lock();
        try {
            this.removeFromCache(clusterName, alias);
            KeyStore ks = this.getCredentialStoreForCluster(clusterName);
            this.removeCredential(alias, ks);
            try {
                this.writeKeystoreToFile(ks, keyStoreFile);
            }
            catch (KeyStoreException e) {
                LOG.failedToRemoveCredentialForCluster(clusterName, e);
            }
            catch (NoSuchAlgorithmException e) {
                LOG.failedToRemoveCredentialForCluster(clusterName, e);
            }
            catch (CertificateException e) {
                LOG.failedToRemoveCredentialForCluster(clusterName, e);
            }
            catch (IOException e) {
                LOG.failedToRemoveCredentialForCluster(clusterName, e);
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    private char[] checkCache(String clusterName, String alias) {
        char[] c = null;
        String cred = null;
        HashMap clusterCache = (HashMap)this.cache.get(clusterName);
        if (clusterCache == null) {
            return null;
        }
        cred = (String)clusterCache.get(alias);
        if (cred != null) {
            c = cred.toCharArray();
        }
        return c;
    }

    private void addToCache(String clusterName, String alias, String credentialString) {
        HashMap<String, String> clusterCache = (HashMap<String, String>)this.cache.get(clusterName);
        if (clusterCache == null) {
            clusterCache = new HashMap<String, String>();
        }
        clusterCache.put(alias, credentialString);
    }

    private void removeFromCache(String clusterName, String alias) {
        HashMap clusterCache = (HashMap)this.cache.get(clusterName);
        if (clusterCache == null) {
            return;
        }
        clusterCache.remove(alias);
    }

    public String getKeystorePath() {
        return this.keyStoreDir + GATEWAY_KEYSTORE;
    }
}

