/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.services.topology.impl;

import java.util.HashMap;
import java.util.Map;
import java.util.ServiceLoader;
import org.apache.knox.gateway.config.GatewayConfig;
import org.apache.knox.gateway.services.ServiceLifecycleException;
import org.apache.knox.gateway.services.security.AliasService;
import org.apache.knox.gateway.topology.ClusterConfigurationMonitorService;
import org.apache.knox.gateway.topology.discovery.ClusterConfigurationMonitor;
import org.apache.knox.gateway.topology.discovery.ClusterConfigurationMonitorProvider;

public class DefaultClusterConfigurationMonitorService
implements ClusterConfigurationMonitorService {
    private AliasService aliasService = null;
    private Map<String, ClusterConfigurationMonitor> monitors = new HashMap<String, ClusterConfigurationMonitor>();

    public void init(GatewayConfig config, Map<String, String> options) throws ServiceLifecycleException {
        ServiceLoader<ClusterConfigurationMonitorProvider> providers = ServiceLoader.load(ClusterConfigurationMonitorProvider.class);
        for (ClusterConfigurationMonitorProvider provider : providers) {
            ClusterConfigurationMonitor monitor;
            if (!config.isClusterMonitorEnabled(provider.getType()) || (monitor = provider.newInstance(config, this.aliasService)) == null) continue;
            this.monitors.put(provider.getType(), monitor);
        }
    }

    public void start() {
        for (ClusterConfigurationMonitor monitor : this.monitors.values()) {
            monitor.start();
        }
    }

    public void stop() {
        for (ClusterConfigurationMonitor monitor : this.monitors.values()) {
            monitor.stop();
        }
    }

    public ClusterConfigurationMonitor getMonitor(String type) {
        return this.monitors.get(type);
    }

    public void addListener(ClusterConfigurationMonitor.ConfigurationChangeListener listener) {
        for (ClusterConfigurationMonitor monitor : this.monitors.values()) {
            monitor.addListener(listener);
        }
    }

    public void clearCache(String source, String clusterName) {
        for (ClusterConfigurationMonitor monitor : this.monitors.values()) {
            monitor.clearCache(source, clusterName);
        }
    }

    public void setAliasService(AliasService aliasService) {
        this.aliasService = aliasService;
    }
}

