/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.authz.support;

import java.util.ArrayList;
import java.util.Collection;
import org.apache.directory.api.ldap.aci.ACITuple;
import org.apache.directory.api.ldap.model.constants.SchemaConstants;
import org.apache.directory.api.ldap.model.entry.Entry;
import org.apache.directory.api.ldap.model.exception.LdapException;
import org.apache.directory.api.ldap.model.exception.LdapNoPermissionException;
import org.apache.directory.api.ldap.model.schema.SchemaManager;
import org.apache.directory.server.core.api.CoreSession;
import org.apache.directory.server.core.api.event.ExpressionEvaluator;
import org.apache.directory.server.core.api.interceptor.context.LookupOperationContext;
import org.apache.directory.server.core.api.subtree.RefinementEvaluator;
import org.apache.directory.server.core.api.subtree.RefinementLeafEvaluator;
import org.apache.directory.server.core.api.subtree.SubtreeEvaluator;
import org.apache.directory.server.core.authz.support.ACITupleFilter;
import org.apache.directory.server.core.authz.support.AciContext;
import org.apache.directory.server.core.authz.support.HighestPrecedenceFilter;
import org.apache.directory.server.core.authz.support.MaxImmSubFilter;
import org.apache.directory.server.core.authz.support.MaxValueCountFilter;
import org.apache.directory.server.core.authz.support.MicroOperationFilter;
import org.apache.directory.server.core.authz.support.MostSpecificProtectedItemFilter;
import org.apache.directory.server.core.authz.support.MostSpecificUserClassFilter;
import org.apache.directory.server.core.authz.support.OperationScope;
import org.apache.directory.server.core.authz.support.RelatedProtectedItemFilter;
import org.apache.directory.server.core.authz.support.RelatedUserClassFilter;
import org.apache.directory.server.core.authz.support.RestrictedByFilter;

public class ACDFEngine {
    private final ACITupleFilter[] filters;

    public ACDFEngine(SchemaManager schemaManager) {
        ExpressionEvaluator entryEvaluator = new ExpressionEvaluator(schemaManager);
        SubtreeEvaluator subtreeEvaluator = new SubtreeEvaluator(schemaManager);
        RefinementEvaluator refinementEvaluator = new RefinementEvaluator(new RefinementLeafEvaluator(schemaManager));
        this.filters = new ACITupleFilter[]{new RelatedUserClassFilter(subtreeEvaluator), new RelatedProtectedItemFilter(refinementEvaluator, entryEvaluator, schemaManager), new MaxValueCountFilter(), new MaxImmSubFilter(schemaManager), new RestrictedByFilter(), new MicroOperationFilter(), new HighestPrecedenceFilter(), new MostSpecificUserClassFilter(), new MostSpecificProtectedItemFilter()};
    }

    public void checkPermission(AciContext aciContext) throws LdapException {
        if (!this.hasPermission(aciContext)) {
            throw new LdapNoPermissionException();
        }
    }

    public boolean hasPermission(AciContext aciContext) throws LdapException {
        if (aciContext.getEntryDn() == null) {
            throw new IllegalArgumentException("entryName");
        }
        CoreSession session = aciContext.getOperationContext().getSession();
        LookupOperationContext lookupContext = new LookupOperationContext(session, aciContext.getUserDn(), SchemaConstants.ALL_ATTRIBUTES_ARRAY);
        Entry userEntry = session.getDirectoryService().getPartitionNexus().lookup(lookupContext);
        OperationScope scope = aciContext.getAttributeType() == null ? OperationScope.ENTRY : (aciContext.getAttrValue() == null ? OperationScope.ATTRIBUTE_TYPE : OperationScope.ATTRIBUTE_TYPE_AND_VALUE);
        aciContext.setAciTuples(new ArrayList<ACITuple>(aciContext.getAciTuples()));
        for (ACITupleFilter filter : this.filters) {
            if (aciContext.getAciTuples().size() == 0) {
                return false;
            }
            Collection<ACITuple> aciTuples = filter.filter(aciContext, scope, userEntry);
            aciContext.setAciTuples(aciTuples);
        }
        if (aciContext.getAciTuples().size() == 0) {
            return false;
        }
        for (ACITuple tuple : aciContext.getAciTuples()) {
            if (tuple.isGrant()) continue;
            return false;
        }
        return true;
    }
}

