/*
 * Decompiled with CFR 0.152.
 */
package com.github.scribejava.apis.fitbit;

import com.github.scribejava.apis.fitbit.FitBitOAuth2AccessToken;
import com.github.scribejava.core.extractors.OAuth2AccessTokenJsonExtractor;
import com.github.scribejava.core.model.OAuth2AccessTokenErrorResponse;
import java.util.regex.Pattern;

public class FitBitJsonTokenExtractor
extends OAuth2AccessTokenJsonExtractor {
    private static final Pattern USER_ID_REGEX_PATTERN = Pattern.compile("\"user_id\"\\s*:\\s*\"(\\S*?)\"");
    private static final Pattern ERROR_REGEX_PATTERN = Pattern.compile("\"errorType\"\\s*:\\s*\"(\\S*?)\"");
    private static final Pattern ERROR_DESCRIPTION_REGEX_PATTERN = Pattern.compile("\"message\"\\s*:\\s*\"([^\"]*?)\"");

    protected FitBitJsonTokenExtractor() {
    }

    public static FitBitJsonTokenExtractor instance() {
        return InstanceHolder.INSTANCE;
    }

    protected FitBitOAuth2AccessToken createToken(String accessToken, String tokenType, Integer expiresIn, String refreshToken, String scope, String response) {
        return new FitBitOAuth2AccessToken(accessToken, tokenType, expiresIn, refreshToken, scope, FitBitJsonTokenExtractor.extractParameter((String)response, (Pattern)USER_ID_REGEX_PATTERN, (boolean)false), response);
    }

    public void generateError(String response) {
        OAuth2AccessTokenErrorResponse.ErrorCode errorCode;
        String errorInString = FitBitJsonTokenExtractor.extractParameter((String)response, (Pattern)ERROR_REGEX_PATTERN, (boolean)true);
        String errorDescription = FitBitJsonTokenExtractor.extractParameter((String)response, (Pattern)ERROR_DESCRIPTION_REGEX_PATTERN, (boolean)false);
        try {
            errorCode = OAuth2AccessTokenErrorResponse.ErrorCode.valueOf((String)errorInString);
        }
        catch (IllegalArgumentException iaE) {
            errorCode = null;
        }
        throw new OAuth2AccessTokenErrorResponse(errorCode, errorDescription, null, response);
    }

    private static class InstanceHolder {
        private static final FitBitJsonTokenExtractor INSTANCE = new FitBitJsonTokenExtractor();

        private InstanceHolder() {
        }
    }
}

