/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.identityasserter.hadoop.groups.filter;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.knox.gateway.deploy.DeploymentContext;
import org.apache.knox.gateway.descriptor.FilterParamDescriptor;
import org.apache.knox.gateway.descriptor.ResourceDescriptor;
import org.apache.knox.gateway.identityasserter.common.filter.AbstractIdentityAsserterDeploymentContributor;
import org.apache.knox.gateway.identityasserter.hadoop.groups.filter.HadoopGroupProviderFilter;
import org.apache.knox.gateway.topology.Provider;
import org.apache.knox.gateway.topology.Service;

public class HadoopGroupProviderDeploymentContributor
extends AbstractIdentityAsserterDeploymentContributor {
    public static final String HADOOP_GROUP_PROVIDER = "HadoopGroupProvider";

    public String getName() {
        return HADOOP_GROUP_PROVIDER;
    }

    protected String getFilterClassname() {
        return HadoopGroupProviderFilter.class.getName();
    }

    public void contributeFilter(DeploymentContext context, Provider provider, Service service, ResourceDescriptor resource, List<FilterParamDescriptor> params) {
        Map p = provider.getParams();
        String prefix = (String)p.get("CENTRAL_GROUP_CONFIG_PREFIX");
        if (prefix != null && !prefix.isEmpty()) {
            Map groupMappingParams;
            if (!prefix.endsWith(".")) {
                prefix = prefix + ".";
            }
            if ((groupMappingParams = ((Configuration)context.getGatewayConfig()).getPropsWithPrefix(prefix)) != null) {
                params = this.createParamList(resource, params, groupMappingParams);
            }
        }
        if (params == null || params.isEmpty()) {
            params = this.buildFilterInitParms(provider, resource, params);
        }
        resource.addFilter().name(this.getName()).role(this.getRole()).impl(this.getFilterClassname()).params(params);
    }

    public List<FilterParamDescriptor> buildFilterInitParms(Provider provider, ResourceDescriptor resource, List<FilterParamDescriptor> params) {
        if (params == null) {
            params = new ArrayList<FilterParamDescriptor>();
        }
        Map providerParams = provider.getParams();
        return this.createParamList(resource, params, providerParams);
    }

    private List<FilterParamDescriptor> createParamList(ResourceDescriptor resource, List<FilterParamDescriptor> params, Map<String, String> providerParams) {
        if (params == null) {
            params = new ArrayList<FilterParamDescriptor>();
        }
        for (Map.Entry<String, String> entry : providerParams.entrySet()) {
            params.add(resource.createFilterParam().name(entry.getKey().toLowerCase(Locale.ROOT)).value(entry.getValue()));
        }
        return params;
    }
}

