/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.topology.discovery.cm.model.hive;

import com.cloudera.api.swagger.client.ApiException;
import com.cloudera.api.swagger.model.ApiConfigList;
import com.cloudera.api.swagger.model.ApiRole;
import com.cloudera.api.swagger.model.ApiService;
import com.cloudera.api.swagger.model.ApiServiceConfig;
import java.util.Locale;
import org.apache.knox.gateway.topology.discovery.cm.ServiceModel;
import org.apache.knox.gateway.topology.discovery.cm.model.AbstractServiceModelGenerator;

public class HiveServiceModelGenerator
extends AbstractServiceModelGenerator {
    private static final String SERVICE = "HIVE";
    private static final String SERVICE_TYPE = "HIVE";
    private static final String ROLE_TYPE = "HIVESERVER2";

    @Override
    public boolean handles(ApiService service, ApiServiceConfig serviceConfig, ApiRole role, ApiConfigList roleConfig) {
        return "HIVE".equals(service.getType()) && ROLE_TYPE.equals(role.getType()) && this.checkHiveServer2HTTPMode(roleConfig);
    }

    @Override
    public ServiceModel generateService(ApiService service, ApiServiceConfig serviceConfig, ApiRole role, ApiConfigList roleConfig) throws ApiException {
        String hostname = role.getHostRef().getHostname();
        String hs2SafetyValve = this.getRoleConfigValue(roleConfig, "hive_hs2_config_safety_valve");
        String port = this.getSafetyValveValue(hs2SafetyValve, "hive.server2.thrift.http.port");
        String httpPath = this.getSafetyValveValue(hs2SafetyValve, "hive.server2.thrift.http.path");
        boolean sslEnabled = Boolean.parseBoolean(this.getRoleConfigValue(roleConfig, "hive.server2.use.SSL"));
        String scheme = sslEnabled ? "https" : "http";
        return new ServiceModel(ServiceModel.Type.API, "HIVE", String.format(Locale.getDefault(), "%s://%s:%s/%s", scheme, hostname, port, httpPath));
    }

    private boolean checkHiveServer2HTTPMode(ApiConfigList roleConfig) {
        String hiveServer2SafetyValve = this.getRoleConfigValue(roleConfig, "hive_hs2_config_safety_valve");
        if (hiveServer2SafetyValve != null) {
            String transportMode = this.getSafetyValveValue(hiveServer2SafetyValve, "hive.server2.transport.mode");
            return "http".equals(transportMode);
        }
        return false;
    }
}

