/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.shrinkwrap.api.asset;

import java.io.BufferedInputStream;
import java.io.InputStream;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.SecurityActions;

public class ClassLoaderAsset
implements Asset {
    private String resourceName;
    private ClassLoader classLoader;

    public ClassLoaderAsset(String resourceName) {
        this(resourceName, SecurityActions.getThreadContextClassLoader());
    }

    public ClassLoaderAsset(String resourceName, ClassLoader classLoader) {
        if (resourceName == null) {
            throw new IllegalArgumentException("ResourceName must be specified");
        }
        if (classLoader == null) {
            throw new IllegalArgumentException("ClassLoader must be specified");
        }
        if (classLoader.getResource(resourceName) == null) {
            throw new IllegalArgumentException(resourceName + " not found in classloader " + classLoader);
        }
        this.resourceName = resourceName;
        this.classLoader = classLoader;
    }

    public String getSource() {
        return this.resourceName;
    }

    public InputStream openStream() {
        return new BufferedInputStream(this.classLoader.getResourceAsStream(this.resourceName), 8192);
    }
}

