/*
 * Decompiled with CFR 0.152.
 */
package de.thetaphi.forbiddenapis.gradle;

import de.thetaphi.forbiddenapis.Checker;
import de.thetaphi.forbiddenapis.Constants;
import de.thetaphi.forbiddenapis.ForbiddenApiException;
import de.thetaphi.forbiddenapis.Logger;
import de.thetaphi.forbiddenapis.ParseException;
import de.thetaphi.forbiddenapis.gradle.CheckForbiddenApisExtension;
import groovy.lang.Closure;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.EnumSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import org.gradle.api.DefaultTask;
import org.gradle.api.GradleException;
import org.gradle.api.Incubating;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.FileTree;
import org.gradle.api.file.FileTreeElement;
import org.gradle.api.resources.ResourceException;
import org.gradle.api.specs.Spec;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputDirectories;
import org.gradle.api.tasks.ParallelizableTask;
import org.gradle.api.tasks.SkipWhenEmpty;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.VerificationTask;
import org.gradle.api.tasks.util.PatternFilterable;
import org.gradle.api.tasks.util.PatternSet;

@ParallelizableTask
public class CheckForbiddenApis
extends DefaultTask
implements PatternFilterable,
VerificationTask,
Constants {
    private static final String NL = System.getProperty("line.separator", "\n");
    private final CheckForbiddenApisExtension data = new CheckForbiddenApisExtension();
    private final PatternSet patternSet = new PatternSet().include(new String[]{"**/*.class"});
    private FileCollection classesDirs;
    private FileCollection classpath;
    private String targetCompatibility;

    @OutputDirectories
    public FileCollection getClassesDirs() {
        return this.classesDirs;
    }

    public void setClassesDirs(FileCollection classesDirs) {
        if (classesDirs == null) {
            throw new NullPointerException("classesDirs");
        }
        this.classesDirs = classesDirs;
    }

    @Deprecated
    public File getClassesDir() {
        FileCollection col = this.getClassesDirs();
        return col == null ? null : col.getSingleFile();
    }

    @Deprecated
    public void setClassesDir(File classesDir) {
        if (classesDir == null) {
            throw new NullPointerException("classesDir");
        }
        this.getLogger().warn("The 'classesDir' property on the '{}' task is deprecated. Use 'classesDirs' of type FileCollection instead!", (Object)this.getName());
        this.setClassesDirs((FileCollection)this.getProject().files(new Object[]{classesDir}));
    }

    public PatternSet getPatternSet() {
        return this.patternSet;
    }

    public void setPatternSet(PatternSet patternSet) {
        patternSet.copyFrom((PatternFilterable)patternSet);
    }

    @InputFiles
    public FileCollection getClasspath() {
        return this.classpath;
    }

    public void setClasspath(FileCollection classpath) {
        if (classpath == null) {
            throw new NullPointerException("classpath");
        }
        this.classpath = classpath;
    }

    @InputFiles
    @Optional
    public FileCollection getSignaturesFiles() {
        return this.data.signaturesFiles;
    }

    public void setSignaturesFiles(FileCollection signaturesFiles) {
        this.data.signaturesFiles = signaturesFiles;
    }

    @Input
    @Optional
    @Incubating
    public Set<URL> getSignaturesURLs() {
        return this.data.signaturesURLs;
    }

    public void setSignaturesURLs(Set<URL> signaturesURLs) {
        this.data.signaturesURLs = signaturesURLs;
    }

    @Input
    @Optional
    public List<String> getSignatures() {
        return this.data.signatures;
    }

    public void setSignatures(List<String> signatures) {
        this.data.signatures = signatures;
    }

    @Input
    @Optional
    public Set<String> getBundledSignatures() {
        return this.data.bundledSignatures;
    }

    public void setBundledSignatures(Set<String> bundledSignatures) {
        this.data.bundledSignatures = bundledSignatures;
    }

    @Deprecated
    @Input
    public boolean getInternalRuntimeForbidden() {
        return this.data.internalRuntimeForbidden;
    }

    @Deprecated
    public void setInternalRuntimeForbidden(boolean internalRuntimeForbidden) {
        this.data.internalRuntimeForbidden = internalRuntimeForbidden;
    }

    @Input
    public boolean getFailOnUnsupportedJava() {
        return this.data.failOnUnsupportedJava;
    }

    public void setFailOnUnsupportedJava(boolean failOnUnsupportedJava) {
        this.data.failOnUnsupportedJava = failOnUnsupportedJava;
    }

    @Input
    public boolean getFailOnMissingClasses() {
        return this.data.failOnMissingClasses;
    }

    public void setFailOnMissingClasses(boolean failOnMissingClasses) {
        this.data.failOnMissingClasses = failOnMissingClasses;
    }

    @Input
    public boolean getFailOnUnresolvableSignatures() {
        return this.data.failOnUnresolvableSignatures;
    }

    public void setFailOnUnresolvableSignatures(boolean failOnUnresolvableSignatures) {
        this.data.failOnUnresolvableSignatures = failOnUnresolvableSignatures;
    }

    @Input
    public boolean getIgnoreFailures() {
        return this.data.ignoreFailures;
    }

    public void setIgnoreFailures(boolean ignoreFailures) {
        this.data.ignoreFailures = ignoreFailures;
    }

    @Input
    public boolean getDisableClassloadingCache() {
        return this.data.disableClassloadingCache;
    }

    public void setDisableClassloadingCache(boolean disableClassloadingCache) {
        this.data.disableClassloadingCache = disableClassloadingCache;
    }

    @Input
    @Optional
    public Set<String> getSuppressAnnotations() {
        return this.data.suppressAnnotations;
    }

    public void setSuppressAnnotations(Set<String> suppressAnnotations) {
        this.data.suppressAnnotations = suppressAnnotations;
    }

    @Input
    @Optional
    public String getTargetCompatibility() {
        return this.targetCompatibility;
    }

    public void setTargetCompatibility(String targetCompatibility) {
        this.targetCompatibility = targetCompatibility;
    }

    @Input
    public Set<String> getIncludes() {
        return this.getPatternSet().getIncludes();
    }

    public CheckForbiddenApis setIncludes(Iterable<String> includes) {
        this.getPatternSet().setIncludes(includes);
        return this;
    }

    @Input
    public Set<String> getExcludes() {
        return this.getPatternSet().getExcludes();
    }

    public CheckForbiddenApis setExcludes(Iterable<String> excludes) {
        this.getPatternSet().setExcludes(excludes);
        return this;
    }

    public CheckForbiddenApis exclude(String ... arg0) {
        this.getPatternSet().exclude(arg0);
        return this;
    }

    public CheckForbiddenApis exclude(Iterable<String> arg0) {
        this.getPatternSet().exclude(arg0);
        return this;
    }

    public CheckForbiddenApis exclude(Spec<FileTreeElement> arg0) {
        this.getPatternSet().exclude(arg0);
        return this;
    }

    public CheckForbiddenApis exclude(Closure arg0) {
        this.getPatternSet().exclude(arg0);
        return this;
    }

    public CheckForbiddenApis include(String ... arg0) {
        this.getPatternSet().include(arg0);
        return this;
    }

    public CheckForbiddenApis include(Iterable<String> arg0) {
        this.getPatternSet().include(arg0);
        return this;
    }

    public CheckForbiddenApis include(Spec<FileTreeElement> arg0) {
        this.getPatternSet().include(arg0);
        return this;
    }

    public CheckForbiddenApis include(Closure arg0) {
        this.getPatternSet().include(arg0);
        return this;
    }

    @InputFiles
    @SkipWhenEmpty
    public FileTree getClassFiles() {
        return this.getClassesDirs().getAsFileTree().matching((PatternFilterable)this.getPatternSet());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @TaskAction
    public void checkForbidden() throws ForbiddenApiException {
        ClassLoader classLoader;
        FileCollection classesDirs = this.getClassesDirs();
        FileCollection classpath = this.getClasspath();
        if (classesDirs == null) throw new InvalidUserDataException("Missing 'classesDirs' or 'classpath' property.");
        if (classpath == null) {
            throw new InvalidUserDataException("Missing 'classesDirs' or 'classpath' property.");
        }
        Logger log = new Logger(){

            @Override
            public void error(String msg) {
                CheckForbiddenApis.this.getLogger().error(msg);
            }

            @Override
            public void warn(String msg) {
                CheckForbiddenApis.this.getLogger().warn(msg);
            }

            @Override
            public void info(String msg) {
                CheckForbiddenApis.this.getLogger().info(msg);
            }
        };
        LinkedHashSet cpElements = new LinkedHashSet();
        cpElements.addAll(classpath.getFiles());
        cpElements.addAll(classesDirs.getFiles());
        URL[] urls = new URL[cpElements.size()];
        try {
            int i = 0;
            for (File cpElement : cpElements) {
                urls[i++] = cpElement.toURI().toURL();
            }
            assert (i == urls.length);
        }
        catch (MalformedURLException mfue) {
            throw new InvalidUserDataException("Failed to build classpath URLs.", (Throwable)mfue);
        }
        URLClassLoader urlLoader = null;
        if (urls.length > 0) {
            urlLoader = URLClassLoader.newInstance(urls, ClassLoader.getSystemClassLoader());
            classLoader = urlLoader;
        } else {
            classLoader = ClassLoader.getSystemClassLoader();
        }
        ClassLoader loader = classLoader;
        try {
            EnumSet<Checker.Option> options = EnumSet.noneOf(Checker.Option.class);
            if (this.getFailOnMissingClasses()) {
                options.add(Checker.Option.FAIL_ON_MISSING_CLASSES);
            }
            if (!this.getIgnoreFailures()) {
                options.add(Checker.Option.FAIL_ON_VIOLATION);
            }
            if (this.getFailOnUnresolvableSignatures()) {
                options.add(Checker.Option.FAIL_ON_UNRESOLVABLE_SIGNATURES);
            }
            if (this.getDisableClassloadingCache()) {
                options.add(Checker.Option.DISABLE_CLASSLOADING_CACHE);
            }
            Checker checker = new Checker(log, loader, options);
            if (!checker.isSupportedJDK) {
                String msg = String.format(Locale.ENGLISH, "Your Java runtime (%s %s) is not supported by the forbiddenapis plugin. Please run the checks with a supported JDK!", System.getProperty("java.runtime.name"), System.getProperty("java.runtime.version"));
                if (this.getFailOnUnsupportedJava()) {
                    throw new GradleException(msg);
                }
                log.warn(msg);
                return;
            }
            Set<String> suppressAnnotations = this.getSuppressAnnotations();
            if (suppressAnnotations != null) {
                for (String a : suppressAnnotations) {
                    checker.addSuppressAnnotation(a);
                }
            }
            try {
                List<String> signatures;
                Set<URL> signaturesURLs;
                FileCollection signaturesFiles;
                Set<String> bundledSignatures = this.getBundledSignatures();
                if (bundledSignatures != null) {
                    String bundledSigsJavaVersion = this.getTargetCompatibility();
                    if (bundledSigsJavaVersion == null) {
                        log.warn("The 'targetCompatibility' project or task property is missing. Trying to read bundled JDK signatures without compiler target. You have to explicitly specify the version in the resource name.");
                    }
                    for (String bs : bundledSignatures) {
                        checker.addBundledSignatures(bs, bundledSigsJavaVersion);
                    }
                }
                if (this.getInternalRuntimeForbidden()) {
                    log.warn(DEPRECATED_WARN_INTERNALRUNTIME);
                    checker.addBundledSignatures("jdk-non-portable", null);
                }
                if ((signaturesFiles = this.getSignaturesFiles()) != null) {
                    for (File f : signaturesFiles) {
                        checker.parseSignaturesFile(f);
                    }
                }
                if ((signaturesURLs = this.getSignaturesURLs()) != null) {
                    for (URL url : signaturesURLs) {
                        checker.parseSignaturesFile(url);
                    }
                }
                if ((signatures = this.getSignatures()) != null && !signatures.isEmpty()) {
                    StringBuilder sb = new StringBuilder();
                    for (String line : signatures) {
                        sb.append(line).append(NL);
                    }
                    checker.parseSignaturesString(sb.toString());
                }
            }
            catch (IOException ioe) {
                throw new ResourceException("IO problem while reading files with API signatures.", (Throwable)ioe);
            }
            catch (ParseException pe) {
                throw new InvalidUserDataException("Parsing signatures failed: " + pe.getMessage(), (Throwable)pe);
            }
            if (checker.hasNoSignatures()) {
                if (options.contains((Object)Checker.Option.FAIL_ON_UNRESOLVABLE_SIGNATURES)) {
                    throw new InvalidUserDataException("No API signatures found; use properties 'signatures', 'bundledSignatures', 'signaturesURLs', and/or 'signaturesFiles' to define those!");
                }
                log.info("Skipping execution because no API signatures are available.");
                return;
            }
            try {
                checker.addClassesToCheck((Iterable<File>)this.getClassFiles());
            }
            catch (IOException ioe) {
                throw new ResourceException("Failed to load one of the given class files.", (Throwable)ioe);
            }
            checker.run();
            return;
        }
        finally {
            if (urlLoader instanceof Closeable) {
                try {
                    ((Closeable)urlLoader).close();
                }
                catch (IOException ioe) {}
            }
        }
    }
}

