/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.jxc;

import com.sun.tools.jxc.Messages;
import com.sun.tools.jxc.SecureLoader;
import com.sun.tools.jxc.ap.Options;
import com.sun.tools.xjc.BadCommandLineException;
import com.sun.xml.bind.util.Which;
import java.io.File;
import java.lang.module.ModuleFinder;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.lang.model.SourceVersion;
import javax.tools.Diagnostic;
import javax.tools.DiagnosticCollector;
import javax.tools.JavaCompiler;
import javax.tools.JavaFileObject;
import javax.tools.OptionChecker;
import javax.tools.StandardJavaFileManager;
import javax.tools.ToolProvider;
import javax.xml.bind.JAXBContext;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class SchemaGenerator {
    private static final Logger LOGGER = Logger.getLogger(SchemaGenerator.class.getName());

    public static void main(String[] stringArray) throws Exception {
        System.exit(SchemaGenerator.run(stringArray));
    }

    public static int run(String[] stringArray) throws Exception {
        try {
            ClassLoader classLoader = SecureLoader.getClassClassLoader(SchemaGenerator.class);
            if (classLoader == null) {
                classLoader = SecureLoader.getSystemClassLoader();
            }
            return SchemaGenerator.run(stringArray, classLoader);
        }
        catch (Exception exception) {
            LOGGER.log(Level.SEVERE, exception.getMessage(), exception);
            return -1;
        }
    }

    public static int run(String[] stringArray, ClassLoader classLoader) throws ClassNotFoundException, NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        String string2;
        Options options = new Options();
        if (stringArray.length == 0) {
            SchemaGenerator.usage();
            return -1;
        }
        for (String string2 : stringArray) {
            if (string2.equals("-help")) {
                SchemaGenerator.usage();
                return -1;
            }
            if (string2.equals("-version")) {
                System.out.println(Messages.VERSION.format(new Object[0]));
                return -1;
            }
            if (!string2.equals("-fullversion")) continue;
            System.out.println(Messages.FULLVERSION.format(new Object[0]));
            return -1;
        }
        try {
            options.parseArguments(stringArray);
        }
        catch (BadCommandLineException badCommandLineException) {
            System.out.println(badCommandLineException.getMessage());
            System.out.println();
            SchemaGenerator.usage();
            return -1;
        }
        Class<?> clazz = classLoader.loadClass(Runner.class.getName());
        Method method = clazz.getDeclaredMethod("compile", String[].class, File.class);
        ArrayList<String> arrayList = new ArrayList<String>();
        if (options.encoding != null) {
            arrayList.add("-encoding");
            arrayList.add(options.encoding);
        }
        if ((string2 = SchemaGenerator.setClasspath(options.classpath)) != null && !string2.isEmpty()) {
            arrayList.add("-cp");
            arrayList.add(string2);
        }
        arrayList.add("--add-modules");
        arrayList.add("java.xml.bind");
        arrayList.add(SchemaGenerator.systemJaxbModule() ? "--upgrade-module-path" : "--module-path");
        arrayList.add(SchemaGenerator.findJaxbApiJar());
        if (options.targetDir != null) {
            arrayList.add("-d");
            arrayList.add(options.targetDir.getPath());
        }
        arrayList.addAll(options.arguments);
        String[] stringArray2 = arrayList.toArray(new String[arrayList.size()]);
        return (Boolean)method.invoke(null, stringArray2, options.episodeFile) != false ? 0 : 1;
    }

    private static boolean systemJaxbModule() {
        ModuleFinder moduleFinder = ModuleFinder.ofSystem();
        return moduleFinder.find("java.xml.bind").isPresent();
    }

    private static String setClasspath(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        SchemaGenerator.appendPath(stringBuilder, string);
        for (ClassLoader classLoader = Thread.currentThread().getContextClassLoader(); classLoader != null; classLoader = classLoader.getParent()) {
            if (!(classLoader instanceof URLClassLoader)) continue;
            for (URL uRL : ((URLClassLoader)classLoader).getURLs()) {
                try {
                    SchemaGenerator.appendPath(stringBuilder, new File(uRL.toURI()).getPath());
                }
                catch (URISyntaxException uRISyntaxException) {
                    LOGGER.log(Level.SEVERE, uRISyntaxException.getMessage(), uRISyntaxException);
                }
            }
        }
        return stringBuilder.toString();
    }

    private static void appendPath(StringBuilder stringBuilder, String string) {
        if (string == null || string.trim().isEmpty()) {
            return;
        }
        if (stringBuilder.length() != 0) {
            stringBuilder.append(File.pathSeparatorChar);
        }
        stringBuilder.append(string);
    }

    private static String findJaxbApiJar() {
        String string = Which.which(JAXBContext.class);
        if (string == null) {
            return null;
        }
        if (!string.startsWith("jar:") || string.lastIndexOf(33) == -1) {
            return null;
        }
        String string2 = string.substring(4, string.lastIndexOf(33));
        if (!string2.startsWith("file:")) {
            return null;
        }
        try {
            File file = new File(new URL(string2).toURI());
            if (file.exists() && file.getName().endsWith(".jar")) {
                return file.getPath();
            }
            file = new File(new URL(string2).getFile());
            if (file.exists() && file.getName().endsWith(".jar")) {
                return file.getPath();
            }
        }
        catch (URISyntaxException uRISyntaxException) {
            LOGGER.log(Level.SEVERE, uRISyntaxException.getMessage(), uRISyntaxException);
        }
        catch (MalformedURLException malformedURLException) {
            LOGGER.log(Level.SEVERE, malformedURLException.getMessage(), malformedURLException);
        }
        return null;
    }

    private static void usage() {
        System.out.println(Messages.USAGE.format(new Object[0]));
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    private static final class JavacOptions {
        private final List<String> recognizedOptions;
        private final List<String> classNames;
        private final List<File> files;
        private final List<String> unrecognizedOptions;

        private JavacOptions(List<String> list, List<String> list2, List<File> list3, List<String> list4) {
            this.recognizedOptions = list;
            this.classNames = list2;
            this.files = list3;
            this.unrecognizedOptions = list4;
        }

        public static JavacOptions parse(OptionChecker optionChecker, OptionChecker optionChecker2, String ... stringArray) {
            ArrayList<String> arrayList = new ArrayList<String>();
            ArrayList<String> arrayList2 = new ArrayList<String>();
            ArrayList<String> arrayList3 = new ArrayList<String>();
            ArrayList<File> arrayList4 = new ArrayList<File>();
            for (int i = 0; i < stringArray.length; ++i) {
                String string = stringArray[i];
                int n = optionChecker.isSupportedOption(string);
                if (n < 0) {
                    n = optionChecker2.isSupportedOption(string);
                }
                if (n < 0) {
                    File file = new File(string);
                    if (file.exists()) {
                        arrayList4.add(file);
                        continue;
                    }
                    if (SourceVersion.isName(string)) {
                        arrayList3.add(string);
                        continue;
                    }
                    arrayList2.add(string);
                    continue;
                }
                for (int j = 0; j < n + 1; ++j) {
                    int n2 = i + j;
                    if (n2 == stringArray.length) {
                        throw new IllegalArgumentException(string);
                    }
                    arrayList.add(stringArray[n2]);
                }
                i += n;
            }
            return new JavacOptions(arrayList, arrayList3, arrayList4, arrayList2);
        }

        public List<String> getRecognizedOptions() {
            return Collections.unmodifiableList(this.recognizedOptions);
        }

        public List<File> getFiles() {
            return Collections.unmodifiableList(this.files);
        }

        public List<String> getClassNames() {
            return Collections.unmodifiableList(this.classNames);
        }

        public List<String> getUnrecognizedOptions() {
            return Collections.unmodifiableList(this.unrecognizedOptions);
        }

        public String toString() {
            return String.format("recognizedOptions = %s; classNames = %s; files = %s; unrecognizedOptions = %s", this.recognizedOptions, this.classNames, this.files, this.unrecognizedOptions);
        }
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    public static final class Runner {
        public static boolean compile(String[] stringArray, File file) throws Exception {
            DiagnosticCollector diagnosticCollector;
            StandardJavaFileManager standardJavaFileManager;
            JavaCompiler javaCompiler = ToolProvider.getSystemJavaCompiler();
            JavacOptions javacOptions = JavacOptions.parse(javaCompiler, standardJavaFileManager = javaCompiler.getStandardFileManager(diagnosticCollector = new DiagnosticCollector(), null, null), stringArray);
            List<String> list = javacOptions.getUnrecognizedOptions();
            if (!list.isEmpty()) {
                LOGGER.log(Level.WARNING, "Unrecognized options found: {0}", list);
            }
            Iterable<? extends JavaFileObject> iterable = standardJavaFileManager.getJavaFileObjectsFromFiles(javacOptions.getFiles());
            JavaCompiler.CompilationTask compilationTask = javaCompiler.getTask(null, standardJavaFileManager, diagnosticCollector, javacOptions.getRecognizedOptions(), javacOptions.getClassNames(), iterable);
            com.sun.tools.jxc.ap.SchemaGenerator schemaGenerator = new com.sun.tools.jxc.ap.SchemaGenerator();
            if (file != null) {
                schemaGenerator.setEpisodeFile(file);
            }
            compilationTask.setProcessors(Collections.singleton(schemaGenerator));
            boolean bl = compilationTask.call();
            for (Diagnostic diagnostic : diagnosticCollector.getDiagnostics()) {
                System.err.println(diagnostic.toString());
            }
            return bl;
        }
    }
}

