/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.as;

import java.net.URISyntaxException;
import org.apache.knox.gateway.deploy.DeploymentContext;
import org.apache.knox.gateway.deploy.ServiceDeploymentContributorBase;
import org.apache.knox.gateway.descriptor.ResourceDescriptor;
import org.apache.knox.gateway.topology.Service;

public class ASDeploymentContributor
extends ServiceDeploymentContributorBase {
    private static final String AS_EXTERNAL_PATH = "/authserver/api/v1";

    public String getRole() {
        return "AS";
    }

    public String getName() {
        return "as";
    }

    public void contributeService(DeploymentContext context, Service service) throws URISyntaxException {
        ResourceDescriptor resource = context.getGatewayDescriptor().addResource();
        resource.role(service.getRole());
        resource.pattern("/authserver/api/v1/authenticate");
        if (this.topologyContainsProviderType(context, "authentication")) {
            context.contributeFilter(service, resource, "authentication", null, null);
        }
        if (this.topologyContainsProviderType(context, "federation")) {
            context.contributeFilter(service, resource, "federation", null, null);
        }
        context.contributeFilter(service, resource, "identity-assertion", null, null);
    }
}

