/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.model.filter;

import org.apache.directory.api.ldap.model.entry.Value;
import org.apache.directory.api.ldap.model.filter.AssertionType;
import org.apache.directory.api.ldap.model.filter.ExprNode;
import org.apache.directory.api.ldap.model.filter.LeafNode;
import org.apache.directory.api.ldap.model.schema.AttributeType;

public class ExtensibleNode
extends LeafNode {
    private Value value;
    protected byte[] bytes;
    private String matchingRuleId;
    private boolean dnAttributes = false;

    public ExtensibleNode(AttributeType attributeType) {
        super(attributeType, AssertionType.EXTENSIBLE);
        this.dnAttributes = false;
    }

    public ExtensibleNode(String attribute) {
        super(attribute, AssertionType.EXTENSIBLE);
        this.dnAttributes = false;
    }

    public ExtensibleNode(AttributeType attributeType, Value value, String matchingRuleId, boolean dnAttributes) {
        super(attributeType, AssertionType.EXTENSIBLE);
        this.value = value;
        this.matchingRuleId = matchingRuleId;
        this.dnAttributes = dnAttributes;
    }

    public ExtensibleNode(String attribute, Value value, String matchingRuleId, boolean dnAttributes) {
        super(attribute, AssertionType.EXTENSIBLE);
        this.value = value;
        this.matchingRuleId = matchingRuleId;
        this.dnAttributes = dnAttributes;
    }

    @Override
    public ExprNode clone() {
        ExprNode clone = super.clone();
        if (this.value != null) {
            ((ExtensibleNode)clone).value = this.value.clone();
        }
        return clone;
    }

    public boolean hasDnAttributes() {
        return this.dnAttributes;
    }

    public void setDnAttributes(boolean dnAttributes) {
        this.dnAttributes = dnAttributes;
    }

    public String getMatchingRuleId() {
        return this.matchingRuleId;
    }

    public void setMatchingRuleId(String matchingRuleId) {
        this.matchingRuleId = matchingRuleId;
    }

    public final Value getValue() {
        return this.value;
    }

    public String getEscapedValue() {
        if (this.value.isHumanReadable()) {
            return ExtensibleNode.escapeFilterValue(this.value.getValue());
        }
        return ExtensibleNode.escapeFilterValue(this.value.getAttributeType(), this.value.getBytes());
    }

    public final void setValue(Value value) {
        this.value = value;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof ExtensibleNode)) {
            return false;
        }
        ExtensibleNode that = (ExtensibleNode)obj;
        if (this.dnAttributes != that.dnAttributes) {
            return false;
        }
        if (!this.matchingRuleId.equals(that.matchingRuleId)) {
            return false;
        }
        if (!this.value.equals(that.value)) {
            return false;
        }
        return super.equals(obj);
    }

    @Override
    public int hashCode() {
        int h = 37;
        h = h * 17 + super.hashCode();
        h = h * 17 + (this.dnAttributes ? 1 : 0);
        h = h * 17 + this.matchingRuleId.hashCode();
        h = h * 17 + this.value.hashCode();
        return h;
    }

    @Override
    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append('(');
        if (this.attributeType != null) {
            buf.append(this.attributeType.getName());
        } else {
            buf.append(this.attribute);
        }
        buf.append("-");
        buf.append(this.dnAttributes);
        buf.append("-EXTENSIBLE-");
        buf.append(this.matchingRuleId);
        buf.append("-");
        buf.append(this.value);
        buf.append(super.toString());
        buf.append(')');
        return buf.toString();
    }
}

