/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.codec.actions.ldapResult;

import org.apache.directory.api.asn1.DecoderException;
import org.apache.directory.api.asn1.ber.grammar.GrammarAction;
import org.apache.directory.api.asn1.ber.tlv.TLV;
import org.apache.directory.api.i18n.I18n;
import org.apache.directory.api.ldap.codec.api.LdapMessageContainer;
import org.apache.directory.api.ldap.codec.api.MessageDecorator;
import org.apache.directory.api.ldap.model.exception.LdapInvalidDnException;
import org.apache.directory.api.ldap.model.message.LdapResult;
import org.apache.directory.api.ldap.model.message.Message;
import org.apache.directory.api.ldap.model.message.ResultCodeEnum;
import org.apache.directory.api.ldap.model.message.ResultResponse;
import org.apache.directory.api.ldap.model.name.Dn;
import org.apache.directory.api.util.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StoreMatchedDN
extends GrammarAction<LdapMessageContainer<MessageDecorator<? extends Message>>> {
    private static final Logger LOG = LoggerFactory.getLogger(StoreMatchedDN.class);

    public StoreMatchedDN() {
        super("Store matched Dn");
    }

    public void action(LdapMessageContainer<MessageDecorator<? extends Message>> container) throws DecoderException {
        Dn matchedDn;
        TLV tlv = container.getCurrentTLV();
        ResultResponse response = (ResultResponse)container.getMessage();
        LdapResult ldapResult = response.getLdapResult();
        ResultCodeEnum resultCode = ldapResult.getResultCode();
        if (tlv.getLength() == 0) {
            matchedDn = Dn.EMPTY_DN;
        } else {
            switch (resultCode) {
                case NO_SUCH_OBJECT: 
                case ALIAS_PROBLEM: 
                case INVALID_DN_SYNTAX: 
                case ALIAS_DEREFERENCING_PROBLEM: {
                    byte[] dnBytes = tlv.getValue().getData();
                    String dnStr = Strings.utf8ToString((byte[])dnBytes);
                    try {
                        matchedDn = new Dn(new String[]{dnStr});
                        break;
                    }
                    catch (LdapInvalidDnException ine) {
                        String msg = I18n.err((I18n)I18n.ERR_05106_INCORRECT_DN_GIVEN_INVALID, (Object[])new Object[]{dnStr, Strings.dumpBytes((byte[])dnBytes), ine.getLocalizedMessage()});
                        LOG.error(msg);
                        throw new DecoderException(I18n.err((I18n)I18n.ERR_05107_INCORRECT_DN_GIVEN, (Object[])new Object[]{ine.getLocalizedMessage()}), (Throwable)ine);
                    }
                }
                default: {
                    if (LOG.isWarnEnabled()) {
                        LOG.warn(I18n.msg((I18n)I18n.MSG_05107_NO_SUCH_OBJECT_MATCHED_DN_NOT_SET, (Object[])new Object[0]));
                    }
                    matchedDn = Dn.EMPTY_DN;
                }
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug(I18n.msg((I18n)I18n.MSG_05108_MATCHED_DN_IS, (Object[])new Object[]{matchedDn}));
        }
        ldapResult.setMatchedDn(matchedDn);
    }
}

