/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.codec.actions.ldapResult;

import org.apache.directory.api.asn1.DecoderException;
import org.apache.directory.api.asn1.ber.grammar.GrammarAction;
import org.apache.directory.api.asn1.ber.tlv.BerValue;
import org.apache.directory.api.asn1.ber.tlv.IntegerDecoder;
import org.apache.directory.api.asn1.ber.tlv.IntegerDecoderException;
import org.apache.directory.api.asn1.ber.tlv.TLV;
import org.apache.directory.api.i18n.I18n;
import org.apache.directory.api.ldap.codec.api.LdapMessageContainer;
import org.apache.directory.api.ldap.codec.api.MessageDecorator;
import org.apache.directory.api.ldap.model.message.LdapResult;
import org.apache.directory.api.ldap.model.message.Message;
import org.apache.directory.api.ldap.model.message.ResultCodeEnum;
import org.apache.directory.api.ldap.model.message.ResultResponse;
import org.apache.directory.api.util.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StoreResultCode
extends GrammarAction<LdapMessageContainer<MessageDecorator<? extends Message>>> {
    private static final Logger LOG = LoggerFactory.getLogger(StoreResultCode.class);

    public StoreResultCode() {
        super("Store resultCode");
    }

    public void action(LdapMessageContainer<MessageDecorator<? extends Message>> container) throws DecoderException {
        TLV tlv = container.getCurrentTLV();
        BerValue value = tlv.getValue();
        ResultCodeEnum resultCode = ResultCodeEnum.SUCCESS;
        try {
            resultCode = ResultCodeEnum.getResultCode((int)IntegerDecoder.parse((BerValue)value, (int)0, (int)ResultCodeEnum.E_SYNC_REFRESH_REQUIRED.getResultCode()));
        }
        catch (IntegerDecoderException ide) {
            LOG.error(I18n.err((I18n)I18n.ERR_05108_INVALID_RESULT_CODE, (Object[])new Object[]{Strings.dumpBytes((byte[])value.getData()), ide.getMessage()}));
            throw new DecoderException(ide.getMessage(), (Throwable)ide);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug(I18n.msg((I18n)I18n.MSG_05109_RESULT_CODE_IS, (Object[])new Object[]{resultCode}));
        }
        ResultResponse response = (ResultResponse)container.getMessage();
        LdapResult ldapResult = response.getLdapResult();
        ldapResult.setResultCode(resultCode);
    }
}

