/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.rm.dispatch;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.atomic.AtomicInteger;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.BufferedHttpEntity;
import org.apache.knox.gateway.dispatch.DefaultDispatch;
import org.apache.knox.gateway.ha.provider.HaProvider;
import org.apache.knox.gateway.i18n.messages.MessagesFactory;
import org.apache.knox.gateway.rm.dispatch.StandbyException;
import org.apache.knox.gateway.rm.i18n.RMMessages;

class RMHaBaseDispatcher
extends DefaultDispatch {
    private static final String FAILOVER_COUNTER_ATTRIBUTE = "dispatch.ha.failover.counter";
    private static final String LOCATION = "Location";
    private static final RMMessages LOG = (RMMessages)MessagesFactory.get(RMMessages.class);
    private int maxFailoverAttempts = 3;
    private int failoverSleep = 1000;
    private String resourceRole;
    private HttpResponse inboundResponse;
    private HaProvider haProvider;

    RMHaBaseDispatcher() {
    }

    private HttpResponse getInboundResponse() {
        HttpResponse response = this.inboundResponse;
        this.setInboundResponse(null);
        return response;
    }

    void setInboundResponse(HttpResponse inboundResponse) {
        this.inboundResponse = inboundResponse;
    }

    void setHaProvider(HaProvider haProvider) {
        this.haProvider = haProvider;
    }

    void setMaxFailoverAttempts(int maxFailoverAttempts) {
        this.maxFailoverAttempts = maxFailoverAttempts;
    }

    void setFailoverSleep(int failoverSleep) {
        this.failoverSleep = failoverSleep;
    }

    void setResourceRole(String resourceRole) {
        this.resourceRole = resourceRole;
    }

    protected void executeRequest(HttpUriRequest outboundRequest, HttpServletRequest inboundRequest, HttpServletResponse outboundResponse) throws IOException {
        HttpResponse inboundResponse = this.getInboundResponse();
        try {
            if (this.getInboundResponse() == null) {
                inboundResponse = this.executeOutboundRequest(outboundRequest);
            }
            this.writeOutboundResponse(outboundRequest, inboundRequest, outboundResponse, inboundResponse);
        }
        catch (StandbyException e) {
            LOG.errorReceivedFromStandbyNode(e);
            this.failoverRequest(outboundRequest, inboundRequest, outboundResponse, inboundResponse, e);
        }
        catch (IOException e) {
            LOG.errorConnectingToServer(outboundRequest.getURI().toString(), e);
            this.failoverRequest(outboundRequest, inboundRequest, outboundResponse, inboundResponse, e);
        }
    }

    protected void writeOutboundResponse(HttpUriRequest outboundRequest, HttpServletRequest inboundRequest, HttpServletResponse outboundResponse, HttpResponse inboundResponse) throws IOException {
        int status = inboundResponse.getStatusLine().getStatusCode();
        if (status == 403 || status == 307) {
            BufferedHttpEntity entity = new BufferedHttpEntity(inboundResponse.getEntity());
            inboundResponse.setEntity((HttpEntity)entity);
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            inboundResponse.getEntity().writeTo((OutputStream)outputStream);
            String body = new String(outputStream.toByteArray(), StandardCharsets.UTF_8);
            if (body.contains("This is standby RM")) {
                throw new StandbyException();
            }
        }
        super.writeOutboundResponse(outboundRequest, inboundRequest, outboundResponse, inboundResponse);
    }

    private void failoverRequest(HttpUriRequest outboundRequest, HttpServletRequest inboundRequest, HttpServletResponse outboundResponse, HttpResponse inboundResponse, Exception exception) throws IOException {
        LOG.failingOverRequest(outboundRequest.getURI().toString());
        AtomicInteger counter = (AtomicInteger)inboundRequest.getAttribute(FAILOVER_COUNTER_ATTRIBUTE);
        if (counter == null) {
            counter = new AtomicInteger(0);
        }
        inboundRequest.setAttribute(FAILOVER_COUNTER_ATTRIBUTE, (Object)counter);
        String outboundURIs = outboundRequest.getURI().toString();
        if (counter.incrementAndGet() <= this.maxFailoverAttempts) {
            inboundRequest.setAttribute("targetRequestUrl", null);
            URI uri = this.getUriFromInbound(inboundRequest, inboundResponse, outboundURIs);
            ((HttpRequestBase)outboundRequest).setURI(uri);
            if (this.failoverSleep > 0) {
                try {
                    Thread.sleep(this.failoverSleep);
                }
                catch (InterruptedException e) {
                    LOG.failoverSleepFailed(this.resourceRole, e);
                }
            }
            this.executeRequest(outboundRequest, inboundRequest, outboundResponse);
        } else {
            LOG.maxFailoverAttemptsReached(this.maxFailoverAttempts, this.resourceRole);
            if (inboundResponse != null) {
                this.writeOutboundResponse(outboundRequest, inboundRequest, outboundResponse, inboundResponse);
            } else {
                throw new IOException(exception);
            }
        }
    }

    URI getUriFromInbound(HttpServletRequest inboundRequest, HttpResponse inboundResponse, String outboundURIs) {
        URI uri;
        if (outboundURIs != null) {
            this.markFailedURL(outboundURIs);
        }
        try {
            if (inboundResponse != null) {
                String host = inboundResponse.getFirstHeader(LOCATION).getValue();
                LOG.failoverRedirect(host);
                uri = URI.create(host);
            } else {
                uri = this.getDispatchUrl(inboundRequest);
            }
        }
        catch (Exception ex) {
            uri = this.getDispatchUrl(inboundRequest);
        }
        this.haProvider.setActiveURL(this.resourceRole, uri.toString());
        return uri;
    }

    private void markFailedURL(String outboundURIs) {
        this.haProvider.markFailedURL(this.resourceRole, outboundURIs);
    }
}

