/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.backend.hashicorp.vault.authentication;

import java.net.URI;
import java.util.Map;
import org.apache.knox.gateway.backend.hashicorp.vault.authentication.HashicorpVaultClientAuthenticationProvider;
import org.apache.knox.gateway.services.security.AliasService;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.vault.authentication.ClientAuthentication;
import org.springframework.vault.authentication.KubernetesAuthentication;
import org.springframework.vault.authentication.KubernetesAuthenticationOptions;
import org.springframework.vault.client.SimpleVaultEndpointProvider;
import org.springframework.vault.client.VaultClients;
import org.springframework.vault.client.VaultEndpoint;
import org.springframework.vault.client.VaultEndpointProvider;
import org.springframework.vault.config.ClientHttpRequestFactoryFactory;
import org.springframework.vault.support.ClientOptions;
import org.springframework.vault.support.SslConfiguration;
import org.springframework.web.client.RestOperations;

public class KubernetesHashicorpVaultClientAuthenticationProvider
implements HashicorpVaultClientAuthenticationProvider {
    public static final String TYPE = "kubernetes";
    public static final String KUBERNETES_ROLE_KEY = "hashicorp.vault.authentication.kubernetes.role";

    @Override
    public String getType() {
        return TYPE;
    }

    @Override
    public ClientAuthentication newInstance(AliasService localAliasService, Map<String, String> properties) throws Exception {
        String role = properties.get(KUBERNETES_ROLE_KEY);
        KubernetesAuthenticationOptions kubernetesAuthenticationOptions = KubernetesAuthenticationOptions.builder().role(role).build();
        return new KubernetesAuthentication(kubernetesAuthenticationOptions, this.getRestOperations(properties));
    }

    private RestOperations getRestOperations(Map<String, String> properties) throws Exception {
        String vaultAddress = properties.get("hashicorp.vault.address");
        VaultEndpoint vaultEndpoint = VaultEndpoint.from((URI)new URI(vaultAddress));
        VaultEndpointProvider vaultEndpointProvider = SimpleVaultEndpointProvider.of((VaultEndpoint)vaultEndpoint);
        ClientOptions clientOptions = new ClientOptions();
        SslConfiguration sslConfiguration = SslConfiguration.unconfigured();
        ClientHttpRequestFactory clientHttpRequestFactory = ClientHttpRequestFactoryFactory.create((ClientOptions)clientOptions, (SslConfiguration)sslConfiguration);
        return VaultClients.createRestTemplate((VaultEndpointProvider)vaultEndpointProvider, (ClientHttpRequestFactory)clientHttpRequestFactory);
    }
}

