/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.libraries.asm.util;

import org.eclipse.persistence.internal.libraries.asm.AnnotationVisitor;
import org.eclipse.persistence.internal.libraries.asm.Type;
import org.eclipse.persistence.internal.libraries.asm.util.CheckMethodAdapter;

public class CheckAnnotationAdapter
extends AnnotationVisitor {
    private final boolean useNamedValue;
    private boolean visitEndCalled;

    public CheckAnnotationAdapter(AnnotationVisitor annotationVisitor) {
        this(annotationVisitor, true);
    }

    CheckAnnotationAdapter(AnnotationVisitor annotationVisitor, boolean bl) {
        super(393216, annotationVisitor);
        this.useNamedValue = bl;
    }

    @Override
    public void visit(String string, Object object) {
        this.checkVisitEndNotCalled();
        this.checkName(string);
        if (!(object instanceof Byte || object instanceof Boolean || object instanceof Character || object instanceof Short || object instanceof Integer || object instanceof Long || object instanceof Float || object instanceof Double || object instanceof String || object instanceof Type || object instanceof byte[] || object instanceof boolean[] || object instanceof char[] || object instanceof short[] || object instanceof int[] || object instanceof long[] || object instanceof float[] || object instanceof double[])) {
            throw new IllegalArgumentException("Invalid annotation value");
        }
        if (object instanceof Type && ((Type)object).getSort() == 11) {
            throw new IllegalArgumentException("Invalid annotation value");
        }
        super.visit(string, object);
    }

    @Override
    public void visitEnum(String string, String string2, String string3) {
        this.checkVisitEndNotCalled();
        this.checkName(string);
        CheckMethodAdapter.checkDescriptor(string2, false);
        if (string3 == null) {
            throw new IllegalArgumentException("Invalid enum value");
        }
        super.visitEnum(string, string2, string3);
    }

    @Override
    public AnnotationVisitor visitAnnotation(String string, String string2) {
        this.checkVisitEndNotCalled();
        this.checkName(string);
        CheckMethodAdapter.checkDescriptor(string2, false);
        return new CheckAnnotationAdapter(super.visitAnnotation(string, string2));
    }

    @Override
    public AnnotationVisitor visitArray(String string) {
        this.checkVisitEndNotCalled();
        this.checkName(string);
        return new CheckAnnotationAdapter(super.visitArray(string), false);
    }

    @Override
    public void visitEnd() {
        this.checkVisitEndNotCalled();
        this.visitEndCalled = true;
        super.visitEnd();
    }

    private void checkName(String string) {
        if (this.useNamedValue && string == null) {
            throw new IllegalArgumentException("Annotation value name must not be null");
        }
    }

    private void checkVisitEndNotCalled() {
        if (this.visitEndCalled) {
            throw new IllegalStateException("Cannot call a visit method after visitEnd has been called");
        }
    }
}

