/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.services.security.impl;

import java.util.Locale;
import org.apache.knox.gateway.GatewayServer;
import org.apache.knox.gateway.config.ConfigurationException;
import org.apache.knox.gateway.security.RemoteAliasServiceProvider;
import org.apache.knox.gateway.services.GatewayServices;
import org.apache.knox.gateway.services.ServiceType;
import org.apache.knox.gateway.services.config.client.RemoteConfigurationRegistryClientService;
import org.apache.knox.gateway.services.security.AliasService;
import org.apache.knox.gateway.services.security.MasterService;
import org.apache.knox.gateway.services.security.impl.ZookeeperRemoteAliasService;
import org.apache.knox.gateway.util.KnoxCLI;

public class ZookeeperRemoteAliasServiceProvider
implements RemoteAliasServiceProvider {
    public String getType() {
        return "zookeeper";
    }

    public AliasService newInstance(AliasService localAliasService, MasterService ms) {
        GatewayServices services;
        GatewayServices gatewayServices = services = GatewayServer.getGatewayServices() != null ? GatewayServer.getGatewayServices() : KnoxCLI.getGatewayServices();
        if (services != null) {
            RemoteConfigurationRegistryClientService registryClientService = (RemoteConfigurationRegistryClientService)services.getService(ServiceType.REMOTE_REGISTRY_CLIENT_SERVICE);
            return new ZookeeperRemoteAliasService(localAliasService, ms, registryClientService);
        }
        throw new ConfigurationException(String.format(Locale.ROOT, "%s service not configured", "ZooKeeper"));
    }
}

