/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.api.partition;

import java.io.IOException;
import java.io.OutputStream;
import java.util.UUID;
import org.apache.directory.api.ldap.model.entry.Entry;
import org.apache.directory.api.ldap.model.exception.LdapException;
import org.apache.directory.api.ldap.model.exception.LdapInvalidDnException;
import org.apache.directory.api.ldap.model.name.Dn;
import org.apache.directory.api.ldap.model.schema.SchemaManager;
import org.apache.directory.server.core.api.CacheService;
import org.apache.directory.server.core.api.filtering.EntryFilteringCursor;
import org.apache.directory.server.core.api.interceptor.context.AddOperationContext;
import org.apache.directory.server.core.api.interceptor.context.DeleteOperationContext;
import org.apache.directory.server.core.api.interceptor.context.HasEntryOperationContext;
import org.apache.directory.server.core.api.interceptor.context.LookupOperationContext;
import org.apache.directory.server.core.api.interceptor.context.ModifyOperationContext;
import org.apache.directory.server.core.api.interceptor.context.MoveAndRenameOperationContext;
import org.apache.directory.server.core.api.interceptor.context.MoveOperationContext;
import org.apache.directory.server.core.api.interceptor.context.RenameOperationContext;
import org.apache.directory.server.core.api.interceptor.context.SearchOperationContext;
import org.apache.directory.server.core.api.interceptor.context.UnbindOperationContext;
import org.apache.directory.server.core.api.partition.PartitionReadTxn;
import org.apache.directory.server.core.api.partition.PartitionTxn;
import org.apache.directory.server.core.api.partition.PartitionWriteTxn;
import org.apache.directory.server.core.api.partition.Subordinates;

public interface Partition {
    public static final String ROOT_ID = new UUID(0L, 0L).toString();
    public static final String DEFAULT_ID = new UUID(0L, 1L).toString();

    public PartitionReadTxn beginReadTransaction();

    public PartitionWriteTxn beginWriteTransaction();

    public String getId();

    public void setId(String var1);

    public SchemaManager getSchemaManager();

    public void setSchemaManager(SchemaManager var1);

    public void initialize() throws LdapException;

    public void repair() throws Exception;

    public Dn getSuffixDn();

    public void setSuffixDn(Dn var1) throws LdapInvalidDnException;

    public void destroy(PartitionTxn var1) throws LdapException;

    public boolean isInitialized();

    public void sync() throws LdapException;

    public Entry delete(DeleteOperationContext var1) throws LdapException;

    public void add(AddOperationContext var1) throws LdapException;

    public void modify(ModifyOperationContext var1) throws LdapException;

    public EntryFilteringCursor search(SearchOperationContext var1) throws LdapException;

    public Entry lookup(LookupOperationContext var1) throws LdapException;

    public boolean hasEntry(HasEntryOperationContext var1) throws LdapException;

    public void rename(RenameOperationContext var1) throws LdapException;

    public void move(MoveOperationContext var1) throws LdapException;

    public void moveAndRename(MoveAndRenameOperationContext var1) throws LdapException;

    public void unbind(UnbindOperationContext var1) throws LdapException;

    public void dumpIndex(PartitionTxn var1, OutputStream var2, String var3) throws IOException;

    public void setCacheService(CacheService var1);

    public String getContextCsn(PartitionTxn var1);

    public void saveContextCsn(PartitionTxn var1) throws LdapException;

    public Subordinates getSubordinates(PartitionTxn var1, Entry var2) throws LdapException;
}

