/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.dispatch;

import java.io.IOException;
import java.util.Locale;
import javax.security.auth.Subject;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.Header;
import org.apache.http.HttpRequest;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.methods.RequestBuilder;
import org.apache.knox.gateway.dispatch.NiFiHaDispatch;
import org.apache.knox.gateway.security.SubjectUtils;
import org.apache.log4j.Logger;

class NiFiRequestUtil {
    NiFiRequestUtil() {
    }

    static HttpUriRequest modifyOutboundRequest(HttpUriRequest outboundRequest, HttpServletRequest inboundRequest) throws IOException {
        Header[] cookieHeaders;
        String xForwardedContextHeaderValue;
        Header originalXForwardedContextHeader;
        String[] split;
        if (inboundRequest.getPathInfo().endsWith("/") && !(split = outboundRequest.getURI().toString().split("\\?"))[0].endsWith("/")) {
            outboundRequest = RequestBuilder.copy((HttpRequest)outboundRequest).setUri(split[0] + "/" + (split.length == 2 ? "?" + split[1] : "")).build();
        }
        if ((originalXForwardedContextHeader = outboundRequest.getFirstHeader("X-Forwarded-Context")) != null && (xForwardedContextHeaderValue = originalXForwardedContextHeader.getValue()) != null && !xForwardedContextHeaderValue.isEmpty()) {
            String inboundRequestPathInfo = inboundRequest.getPathInfo();
            String outboundRequestUriPath = outboundRequest.getURI().getPath();
            String outboundRequestUriPathNoTrailingSlash = StringUtils.removeEnd((String)outboundRequestUriPath, (String)"/");
            String knoxRouteContext = null;
            int index = inboundRequestPathInfo.lastIndexOf(outboundRequestUriPathNoTrailingSlash);
            if (index >= 0) {
                knoxRouteContext = inboundRequestPathInfo.substring(0, index);
            } else {
                Logger.getLogger((String)NiFiHaDispatch.class.getName()).error((Object)String.format(Locale.ROOT, "Unable to find index of %s in %s", outboundRequestUriPathNoTrailingSlash, inboundRequestPathInfo));
            }
            outboundRequest.setHeader("X-Forwarded-Context", xForwardedContextHeaderValue + knoxRouteContext);
        }
        Subject subject = SubjectUtils.getCurrentSubject();
        String effectivePrincipalName = SubjectUtils.getEffectivePrincipalName((Subject)subject);
        String proxiedEntitesChainHeader = inboundRequest.getHeader("X-ProxiedEntitiesChain");
        if (proxiedEntitesChainHeader == null) {
            proxiedEntitesChainHeader = "";
        }
        outboundRequest.setHeader("X-ProxiedEntitiesChain", proxiedEntitesChainHeader + String.format(Locale.ROOT, "<%s>", "anonymous".equalsIgnoreCase(effectivePrincipalName) ? "" : effectivePrincipalName));
        for (Header cookieHeader : cookieHeaders = outboundRequest.getHeaders("Cookie")) {
            outboundRequest.removeHeader(cookieHeader);
        }
        return outboundRequest;
    }
}

