/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.libraries.asm;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;

public class Type {
    public static final int VOID = 0;
    public static final int BOOLEAN = 1;
    public static final int CHAR = 2;
    public static final int BYTE = 3;
    public static final int SHORT = 4;
    public static final int INT = 5;
    public static final int FLOAT = 6;
    public static final int LONG = 7;
    public static final int DOUBLE = 8;
    public static final int ARRAY = 9;
    public static final int OBJECT = 10;
    public static final int METHOD = 11;
    private static final int INTERNAL = 12;
    private static final char[] PRIMITIVE_DESCRIPTORS = new char[]{'V', 'Z', 'C', 'B', 'S', 'I', 'F', 'J', 'D'};
    public static final Type VOID_TYPE = new Type(0, PRIMITIVE_DESCRIPTORS, 0, 1);
    public static final Type BOOLEAN_TYPE = new Type(1, PRIMITIVE_DESCRIPTORS, 1, 1);
    public static final Type CHAR_TYPE = new Type(2, PRIMITIVE_DESCRIPTORS, 2, 1);
    public static final Type BYTE_TYPE = new Type(3, PRIMITIVE_DESCRIPTORS, 3, 1);
    public static final Type SHORT_TYPE = new Type(4, PRIMITIVE_DESCRIPTORS, 4, 1);
    public static final Type INT_TYPE = new Type(5, PRIMITIVE_DESCRIPTORS, 5, 1);
    public static final Type FLOAT_TYPE = new Type(6, PRIMITIVE_DESCRIPTORS, 6, 1);
    public static final Type LONG_TYPE = new Type(7, PRIMITIVE_DESCRIPTORS, 7, 1);
    public static final Type DOUBLE_TYPE = new Type(8, PRIMITIVE_DESCRIPTORS, 8, 1);
    private final int sort;
    private final char[] valueBuffer;
    private final int valueOffset;
    private final int valueLength;

    private Type(int n, char[] cArray, int n2, int n3) {
        this.sort = n;
        this.valueBuffer = cArray;
        this.valueOffset = n2;
        this.valueLength = n3;
    }

    public static Type getType(String string) {
        char[] cArray = string.toCharArray();
        return Type.getType(cArray, 0, cArray.length);
    }

    public static Type getObjectType(String string) {
        char[] cArray = string.toCharArray();
        return new Type(cArray[0] == '[' ? 9 : 12, cArray, 0, cArray.length);
    }

    public static Type getMethodType(String string) {
        char[] cArray = string.toCharArray();
        return new Type(11, cArray, 0, cArray.length);
    }

    public static Type getMethodType(Type type, Type ... typeArray) {
        return Type.getType(Type.getMethodDescriptor(type, typeArray));
    }

    public static Type getType(Class<?> clazz) {
        if (clazz.isPrimitive()) {
            if (clazz == Integer.TYPE) {
                return INT_TYPE;
            }
            if (clazz == Void.TYPE) {
                return VOID_TYPE;
            }
            if (clazz == Boolean.TYPE) {
                return BOOLEAN_TYPE;
            }
            if (clazz == Byte.TYPE) {
                return BYTE_TYPE;
            }
            if (clazz == Character.TYPE) {
                return CHAR_TYPE;
            }
            if (clazz == Short.TYPE) {
                return SHORT_TYPE;
            }
            if (clazz == Double.TYPE) {
                return DOUBLE_TYPE;
            }
            if (clazz == Float.TYPE) {
                return FLOAT_TYPE;
            }
            if (clazz == Long.TYPE) {
                return LONG_TYPE;
            }
            throw new AssertionError();
        }
        return Type.getType(Type.getDescriptor(clazz));
    }

    public static Type getType(Constructor<?> constructor) {
        return Type.getType(Type.getConstructorDescriptor(constructor));
    }

    public static Type getType(Method method) {
        return Type.getType(Type.getMethodDescriptor(method));
    }

    public static Type[] getArgumentTypes(String string) {
        char[] cArray = string.toCharArray();
        int n = 0;
        int n2 = 1;
        while (cArray[n2] != ')') {
            while (cArray[n2] == '[') {
                ++n2;
            }
            if (cArray[n2++] == 'L') {
                while (cArray[n2++] != ';') {
                }
            }
            ++n;
        }
        Type[] typeArray = new Type[n];
        n2 = 1;
        int n3 = 0;
        while (cArray[n2] != ')') {
            int n4 = n2;
            while (cArray[n2] == '[') {
                ++n2;
            }
            if (cArray[n2++] == 'L') {
                while (cArray[n2++] != ';') {
                }
            }
            typeArray[n3++] = Type.getType(cArray, n4, n2 - n4);
        }
        return typeArray;
    }

    public static Type[] getArgumentTypes(Method method) {
        Class<?>[] classArray = method.getParameterTypes();
        Type[] typeArray = new Type[classArray.length];
        for (int i = classArray.length - 1; i >= 0; --i) {
            typeArray[i] = Type.getType(classArray[i]);
        }
        return typeArray;
    }

    public static Type getReturnType(String string) {
        char[] cArray = string.toCharArray();
        int n = 1;
        while (cArray[n] != ')') {
            while (cArray[n] == '[') {
                ++n;
            }
            if (cArray[n++] != 'L') continue;
            while (cArray[n++] != ';') {
            }
        }
        return Type.getType(cArray, n + 1, cArray.length - n - 1);
    }

    public static Type getReturnType(Method method) {
        return Type.getType(method.getReturnType());
    }

    public static int getArgumentsAndReturnSizes(String string) {
        int n = 1;
        int n2 = 1;
        char c = string.charAt(n2);
        while (c != ')') {
            if (c == 'J' || c == 'D') {
                ++n2;
                n += 2;
            } else {
                while (string.charAt(n2) == '[') {
                    ++n2;
                }
                if (string.charAt(n2++) == 'L') {
                    while (string.charAt(n2++) != ';') {
                    }
                }
                ++n;
            }
            c = string.charAt(n2);
        }
        c = string.charAt(n2 + 1);
        if (c == 'V') {
            return n << 2;
        }
        int n3 = c == 'J' || c == 'D' ? 2 : 1;
        return n << 2 | n3;
    }

    private static Type getType(char[] cArray, int n, int n2) {
        switch (cArray[n]) {
            case 'V': {
                return VOID_TYPE;
            }
            case 'Z': {
                return BOOLEAN_TYPE;
            }
            case 'C': {
                return CHAR_TYPE;
            }
            case 'B': {
                return BYTE_TYPE;
            }
            case 'S': {
                return SHORT_TYPE;
            }
            case 'I': {
                return INT_TYPE;
            }
            case 'F': {
                return FLOAT_TYPE;
            }
            case 'J': {
                return LONG_TYPE;
            }
            case 'D': {
                return DOUBLE_TYPE;
            }
            case '[': {
                return new Type(9, cArray, n, n2);
            }
            case 'L': {
                return new Type(10, cArray, n + 1, n2 - 2);
            }
            case '(': {
                return new Type(11, cArray, n, n2);
            }
        }
        throw new IllegalArgumentException();
    }

    public int getSort() {
        return this.sort == 12 ? 10 : this.sort;
    }

    public int getDimensions() {
        int n = 1;
        while (this.valueBuffer[this.valueOffset + n] == '[') {
            ++n;
        }
        return n;
    }

    public Type getElementType() {
        int n = this.getDimensions();
        return Type.getType(this.valueBuffer, this.valueOffset + n, this.valueLength - n);
    }

    public String getClassName() {
        switch (this.sort) {
            case 0: {
                return "void";
            }
            case 1: {
                return "boolean";
            }
            case 2: {
                return "char";
            }
            case 3: {
                return "byte";
            }
            case 4: {
                return "short";
            }
            case 5: {
                return "int";
            }
            case 6: {
                return "float";
            }
            case 7: {
                return "long";
            }
            case 8: {
                return "double";
            }
            case 9: {
                StringBuilder stringBuilder = new StringBuilder(this.getElementType().getClassName());
                for (int i = this.getDimensions(); i > 0; --i) {
                    stringBuilder.append("[]");
                }
                return stringBuilder.toString();
            }
            case 10: 
            case 12: {
                return new String(this.valueBuffer, this.valueOffset, this.valueLength).replace('/', '.');
            }
        }
        throw new AssertionError();
    }

    public String getInternalName() {
        return new String(this.valueBuffer, this.valueOffset, this.valueLength);
    }

    public Type[] getArgumentTypes() {
        return Type.getArgumentTypes(this.getDescriptor());
    }

    public Type getReturnType() {
        return Type.getReturnType(this.getDescriptor());
    }

    public int getArgumentsAndReturnSizes() {
        return Type.getArgumentsAndReturnSizes(this.getDescriptor());
    }

    public String getDescriptor() {
        if (this.sort == 10) {
            return new String(this.valueBuffer, this.valueOffset - 1, this.valueLength + 2);
        }
        if (this.sort == 12) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append('L');
            stringBuilder.append(this.valueBuffer, this.valueOffset, this.valueLength);
            stringBuilder.append(';');
            return stringBuilder.toString();
        }
        return new String(this.valueBuffer, this.valueOffset, this.valueLength);
    }

    public static String getMethodDescriptor(Type type, Type ... typeArray) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append('(');
        for (int i = 0; i < typeArray.length; ++i) {
            typeArray[i].appendDescriptor(stringBuilder);
        }
        stringBuilder.append(')');
        type.appendDescriptor(stringBuilder);
        return stringBuilder.toString();
    }

    private void appendDescriptor(StringBuilder stringBuilder) {
        if (this.sort == 10) {
            stringBuilder.append(this.valueBuffer, this.valueOffset - 1, this.valueLength + 2);
        } else if (this.sort == 12) {
            stringBuilder.append('L');
            stringBuilder.append(this.valueBuffer, this.valueOffset, this.valueLength);
            stringBuilder.append(';');
        } else {
            stringBuilder.append(this.valueBuffer, this.valueOffset, this.valueLength);
        }
    }

    public static String getInternalName(Class<?> clazz) {
        return clazz.getName().replace('.', '/');
    }

    public static String getDescriptor(Class<?> clazz) {
        StringBuilder stringBuilder = new StringBuilder();
        Type.appendDescriptor(stringBuilder, clazz);
        return stringBuilder.toString();
    }

    public static String getConstructorDescriptor(Constructor<?> constructor) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append('(');
        Class<?>[] classArray = constructor.getParameterTypes();
        for (int i = 0; i < classArray.length; ++i) {
            Type.appendDescriptor(stringBuilder, classArray[i]);
        }
        return stringBuilder.append(")V").toString();
    }

    public static String getMethodDescriptor(Method method) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append('(');
        Class<?>[] classArray = method.getParameterTypes();
        for (int i = 0; i < classArray.length; ++i) {
            Type.appendDescriptor(stringBuilder, classArray[i]);
        }
        stringBuilder.append(')');
        Type.appendDescriptor(stringBuilder, method.getReturnType());
        return stringBuilder.toString();
    }

    private static void appendDescriptor(StringBuilder stringBuilder, Class<?> clazz) {
        Class<?> clazz2 = clazz;
        while (clazz2.isArray()) {
            stringBuilder.append('[');
            clazz2 = clazz2.getComponentType();
        }
        if (clazz2.isPrimitive()) {
            int n;
            if (clazz2 == Integer.TYPE) {
                n = 73;
            } else if (clazz2 == Void.TYPE) {
                n = 86;
            } else if (clazz2 == Boolean.TYPE) {
                n = 90;
            } else if (clazz2 == Byte.TYPE) {
                n = 66;
            } else if (clazz2 == Character.TYPE) {
                n = 67;
            } else if (clazz2 == Short.TYPE) {
                n = 83;
            } else if (clazz2 == Double.TYPE) {
                n = 68;
            } else if (clazz2 == Float.TYPE) {
                n = 70;
            } else if (clazz2 == Long.TYPE) {
                n = 74;
            } else {
                throw new AssertionError();
            }
            stringBuilder.append((char)n);
        } else {
            stringBuilder.append('L');
            String string = clazz2.getName();
            int n = string.length();
            for (int i = 0; i < n; ++i) {
                char c = string.charAt(i);
                stringBuilder.append(c == '.' ? (char)'/' : (char)c);
            }
            stringBuilder.append(';');
        }
    }

    public int getSize() {
        switch (this.sort) {
            case 0: {
                return 0;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 9: 
            case 10: 
            case 12: {
                return 1;
            }
            case 7: 
            case 8: {
                return 2;
            }
        }
        throw new AssertionError();
    }

    public int getOpcode(int n) {
        if (n == 46 || n == 79) {
            switch (this.sort) {
                case 1: 
                case 3: {
                    return n + 5;
                }
                case 2: {
                    return n + 6;
                }
                case 4: {
                    return n + 7;
                }
                case 5: {
                    return n;
                }
                case 6: {
                    return n + 2;
                }
                case 7: {
                    return n + 1;
                }
                case 8: {
                    return n + 3;
                }
                case 9: 
                case 10: 
                case 12: {
                    return n + 4;
                }
                case 0: 
                case 11: {
                    throw new UnsupportedOperationException();
                }
            }
            throw new AssertionError();
        }
        switch (this.sort) {
            case 0: {
                if (n != 172) {
                    throw new UnsupportedOperationException();
                }
                return 177;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                return n;
            }
            case 6: {
                return n + 2;
            }
            case 7: {
                return n + 1;
            }
            case 8: {
                return n + 3;
            }
            case 9: 
            case 10: 
            case 12: {
                if (n != 21 && n != 54 && n != 172) {
                    throw new UnsupportedOperationException();
                }
                return n + 4;
            }
            case 11: {
                throw new UnsupportedOperationException();
            }
        }
        throw new AssertionError();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof Type)) {
            return false;
        }
        Type type = (Type)object;
        if ((this.sort == 12 ? 10 : this.sort) != (type.sort == 12 ? 10 : type.sort)) {
            return false;
        }
        int n = this.valueOffset;
        int n2 = n + this.valueLength;
        int n3 = type.valueOffset;
        int n4 = n3 + type.valueLength;
        if (n2 - n != n4 - n3) {
            return false;
        }
        int n5 = n;
        int n6 = n3;
        while (n5 < n2) {
            if (this.valueBuffer[n5] != type.valueBuffer[n6]) {
                return false;
            }
            ++n5;
            ++n6;
        }
        return true;
    }

    public int hashCode() {
        int n = 13 * (this.sort == 12 ? 10 : this.sort);
        if (this.sort >= 9) {
            int n2 = this.valueOffset + this.valueLength;
            for (int i = this.valueOffset; i < n2; ++i) {
                n = 17 * (n + this.valueBuffer[i]);
            }
        }
        return n;
    }

    public String toString() {
        return this.getDescriptor();
    }
}

