/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.config.builder;

import java.util.Map;
import org.ldaptive.ConnectionFactory;
import org.ldaptive.auth.Authenticator;
import org.ldaptive.pool.PooledConnectionFactoryManager;
import org.ldaptive.sasl.Mechanism;
import org.ldaptive.sasl.QualityOfProtection;
import org.ldaptive.sasl.SecurityStrength;
import org.pac4j.config.builder.AbstractBuilder;
import org.pac4j.config.ldaptive.LdapAuthenticationProperties;
import org.pac4j.config.ldaptive.LdaptiveAuthenticatorBuilder;
import org.pac4j.core.util.CommonHelper;
import org.pac4j.ldap.profile.service.LdapProfileService;

public class LdapAuthenticatorBuilder
extends AbstractBuilder {
    public LdapAuthenticatorBuilder(Map<String, String> properties) {
        super(properties);
    }

    public void tryBuildLdapAuthenticator(Map<String, org.pac4j.core.credentials.authenticator.Authenticator> authenticators) {
        for (int i = 0; i <= 10; ++i) {
            String type = this.getProperty("ldap.type", i);
            if (!CommonHelper.isNotBlank((String)type)) continue;
            LdapAuthenticationProperties ldapProp = this.buildLdapProperties(i);
            Authenticator ldaptiveAuthenticator = LdaptiveAuthenticatorBuilder.getAuthenticator(ldapProp);
            LdapProfileService authenticator = new LdapProfileService(ldaptiveAuthenticator, this.getProperty("ldap.principalAttributes", i));
            PooledConnectionFactoryManager pooledConnectionFactoryManager = (PooledConnectionFactoryManager)ldaptiveAuthenticator.getAuthenticationHandler();
            authenticator.setConnectionFactory((ConnectionFactory)pooledConnectionFactoryManager.getConnectionFactory());
            authenticator.setUsersDn(this.getProperty("ldap.usersDn", i));
            if (this.containsProperty("ldap.principalAttributeId", i)) {
                authenticator.setUsernameAttribute(this.getProperty("ldap.principalAttributeId", i));
            }
            if (this.containsProperty("ldap.principalAttributePassword", i)) {
                authenticator.setPasswordAttribute(this.getProperty("ldap.principalAttributePassword", i));
            }
            authenticators.put(this.concat("ldap", i), (org.pac4j.core.credentials.authenticator.Authenticator)authenticator);
        }
    }

    private LdapAuthenticationProperties buildLdapProperties(int i) {
        LdapAuthenticationProperties ldapProp = new LdapAuthenticationProperties();
        String type = this.getProperty("ldap.type", i);
        ldapProp.setType(LdapAuthenticationProperties.AuthenticationTypes.valueOf(type.toUpperCase()));
        ldapProp.setDnFormat(this.getProperty("ldap.dnFormat", i));
        if (this.containsProperty("ldap.principalAttributePassword", i)) {
            ldapProp.setPrincipalAttributePassword(this.getProperty("ldap.principalAttributePassword", i));
        }
        if (this.containsProperty("ldap.subtreeSearch", i)) {
            ldapProp.setSubtreeSearch(this.getPropertyAsBoolean("ldap.subtreeSearch", i));
        }
        ldapProp.setBaseDn(this.getProperty("ldap.usersDn", i));
        ldapProp.setUserFilter(this.getProperty("ldap.userFilter", i));
        if (this.containsProperty("ldap.enhanceWithEntryResolver", i)) {
            ldapProp.setEnhanceWithEntryResolver(this.getPropertyAsBoolean("ldap.enhanceWithEntryResolver", i));
        }
        ldapProp.setLdapUrl(this.getProperty("ldap.url", i));
        if (this.containsProperty("ldap.trustCertificates", i)) {
            ldapProp.setTrustCertificates(this.getProperty("ldap.trustCertificates", i));
        }
        if (this.containsProperty("ldap.keystore", i)) {
            ldapProp.setKeystore(this.getProperty("ldap.keystore", i));
        }
        if (this.containsProperty("ldap.keystorePassword", i)) {
            ldapProp.setKeystorePassword(this.getProperty("ldap.keystorePassword", i));
        }
        if (this.containsProperty("ldap.keystoreType", i)) {
            ldapProp.setKeystoreType(this.getProperty("ldap.keystoreType", i));
        }
        if (this.containsProperty("ldap.minPoolSize", i)) {
            ldapProp.setMinPoolSize(this.getPropertyAsInteger("ldap.minPoolSize", i));
        }
        if (this.containsProperty("ldap.maxPoolSize", i)) {
            ldapProp.setMinPoolSize(this.getPropertyAsInteger("ldap.maxPoolSize", i));
        }
        if (this.containsProperty("ldap.poolPassivator", i)) {
            ldapProp.setPoolPassivator(this.getProperty("ldap.poolPassivator", i));
        }
        if (this.containsProperty("ldap.validateOnCheckout", i)) {
            ldapProp.setValidateOnCheckout(this.getPropertyAsBoolean("ldap.validateOnCheckout", i));
        }
        if (this.containsProperty("ldap.validatePeriodically", i)) {
            ldapProp.setValidatePeriodically(this.getPropertyAsBoolean("ldap.validatePeriodically", i));
        }
        if (this.containsProperty("ldap.validatePeriod", i)) {
            ldapProp.setValidatePeriod(this.getPropertyAsLong("ldap.validatePeriod", i));
        }
        if (this.containsProperty("ldap.failFast", i)) {
            ldapProp.setFailFast(this.getPropertyAsBoolean("ldap.failFast", i));
        }
        if (this.containsProperty("ldap.idleTime", i)) {
            ldapProp.setIdleTime(this.getPropertyAsLong("ldap.idleTime", i));
        }
        if (this.containsProperty("ldap.prunePeriod", i)) {
            ldapProp.setPrunePeriod(this.getPropertyAsLong("ldap.prunePeriod", i));
        }
        if (this.containsProperty("ldap.blockWaitTime", i)) {
            ldapProp.setBlockWaitTime(this.getPropertyAsLong("ldap.blockWaitTime", i));
        }
        if (this.containsProperty("ldap.useSsl", i)) {
            ldapProp.setUseSsl(this.getPropertyAsBoolean("ldap.useSsl", i));
        }
        if (this.containsProperty("ldap.useStartTls", i)) {
            ldapProp.setUseStartTls(this.getPropertyAsBoolean("ldap.useStartTls", i));
        }
        if (this.containsProperty("ldap.connectTimeout", i)) {
            ldapProp.setConnectTimeout(this.getPropertyAsLong("ldap.connectTimeout", i));
        }
        if (this.containsProperty("ldap.providerClass", i)) {
            ldapProp.setProviderClass(this.getProperty("ldap.providerClass", i));
        }
        if (this.containsProperty("ldap.allowMultipleDns", i)) {
            ldapProp.setAllowMultipleDns(this.getPropertyAsBoolean("ldap.allowMultipleDns", i));
        }
        if (this.containsProperty("ldap.bindDn", i)) {
            ldapProp.setBindDn(this.getProperty("ldap.bindDn", i));
        }
        if (this.containsProperty("ldap.bindCredential", i)) {
            ldapProp.setBindCredential(this.getProperty("ldap.bindCredential", i));
        }
        if (this.containsProperty("ldap.saslRealm", i)) {
            ldapProp.setSaslRealm(this.getProperty("ldap.saslRealm", i));
        }
        if (this.containsProperty("ldap.saslMechanism", i)) {
            ldapProp.setSaslMechanism(Mechanism.valueOf((String)this.getProperty("ldap.saslMechanism", i).toUpperCase()));
        }
        if (this.containsProperty("ldap.saslAuthorizationId", i)) {
            ldapProp.setSaslAuthorizationId(this.getProperty("ldap.saslAuthorizationId", i));
        }
        if (this.containsProperty("ldap.saslSecurityStrength", i)) {
            ldapProp.setSaslSecurityStrength(SecurityStrength.valueOf((String)this.getProperty("ldap.saslSecurityStrength", i).toUpperCase()));
        }
        if (this.containsProperty("ldap.saslQualityOfProtection", i)) {
            ldapProp.setSaslQualityOfProtection(QualityOfProtection.valueOf((String)this.getProperty("ldap.saslQualityOfProtection", i).toUpperCase()));
        }
        return ldapProp;
    }
}

