/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.service.config.remote.zk;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.curator.RetryPolicy;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.CuratorFrameworkFactory;
import org.apache.curator.framework.api.ACLProvider;
import org.apache.curator.framework.api.BackgroundPathable;
import org.apache.curator.framework.imps.DefaultACLProvider;
import org.apache.curator.framework.recipes.cache.ChildData;
import org.apache.curator.framework.recipes.cache.NodeCache;
import org.apache.curator.framework.recipes.cache.NodeCacheListener;
import org.apache.curator.framework.recipes.cache.PathChildrenCache;
import org.apache.curator.framework.recipes.cache.PathChildrenCacheEvent;
import org.apache.curator.framework.recipes.cache.PathChildrenCacheListener;
import org.apache.curator.retry.ExponentialBackoffRetry;
import org.apache.knox.gateway.config.ConfigurationException;
import org.apache.knox.gateway.config.GatewayConfig;
import org.apache.knox.gateway.i18n.messages.MessagesFactory;
import org.apache.knox.gateway.service.config.remote.RemoteConfigurationMessages;
import org.apache.knox.gateway.service.config.remote.RemoteConfigurationRegistryConfig;
import org.apache.knox.gateway.service.config.remote.config.RemoteConfigurationRegistriesAccessor;
import org.apache.knox.gateway.service.config.remote.zk.RemoteConfigurationRegistryJAASConfig;
import org.apache.knox.gateway.service.config.remote.zk.ZooKeeperClientService;
import org.apache.knox.gateway.services.ServiceLifecycleException;
import org.apache.knox.gateway.services.config.client.RemoteConfigurationRegistryClient;
import org.apache.knox.gateway.services.security.AliasService;
import org.apache.zookeeper.ZooDefs;
import org.apache.zookeeper.data.ACL;
import org.apache.zookeeper.data.Id;
import org.apache.zookeeper.data.Stat;

class CuratorClientService
implements ZooKeeperClientService {
    private static final String LOGIN_CONTEXT_NAME_PROPERTY = "zookeeper.sasl.clientconfig";
    private static final String DEFAULT_LOGIN_CONTEXT_NAME = "Client";
    private static final RemoteConfigurationMessages log = (RemoteConfigurationMessages)MessagesFactory.get(RemoteConfigurationMessages.class);
    private Map<String, RemoteConfigurationRegistryClient> clients = new HashMap<String, RemoteConfigurationRegistryClient>();
    private AliasService aliasService;

    CuratorClientService() {
    }

    public void init(GatewayConfig config, Map<String, String> options) throws ServiceLifecycleException {
        ArrayList<RemoteConfigurationRegistryConfig> registryConfigs = new ArrayList<RemoteConfigurationRegistryConfig>(RemoteConfigurationRegistriesAccessor.getRemoteRegistryConfigurations(config));
        try {
            RemoteConfigurationRegistryJAASConfig.configure(registryConfigs, this.aliasService);
        }
        catch (ConfigurationException e) {
            throw new ServiceLifecycleException("Error while configuring registry authentication", (Exception)((Object)e));
        }
        if (registryConfigs.size() > 1) {
            log.multipleRemoteRegistryConfigurations();
        }
        for (RemoteConfigurationRegistryConfig registryConfig : registryConfigs) {
            if (!"ZooKeeper".equalsIgnoreCase(registryConfig.getRegistryType())) continue;
            RemoteConfigurationRegistryClient registryClient = this.createClient(registryConfig);
            this.clients.put(registryConfig.getName(), registryClient);
        }
    }

    public void setAliasService(AliasService aliasService) {
        this.aliasService = aliasService;
    }

    public void start() throws ServiceLifecycleException {
    }

    public void stop() throws ServiceLifecycleException {
        for (RemoteConfigurationRegistryClient client : this.clients.values()) {
            try {
                client.close();
            }
            catch (Exception e) {
                throw new ServiceLifecycleException("failed to close client", e);
            }
        }
    }

    public RemoteConfigurationRegistryClient get(String name) {
        return this.clients.get(name);
    }

    private RemoteConfigurationRegistryClient createClient(RemoteConfigurationRegistryConfig config) {
        SASLOwnerACLProvider aclProvider;
        if (config.isSecureRegistry()) {
            this.configureSasl(config);
            aclProvider = new SASLOwnerACLProvider();
        } else {
            System.clearProperty(LOGIN_CONTEXT_NAME_PROPERTY);
            aclProvider = new DefaultACLProvider();
        }
        CuratorFramework client = CuratorFrameworkFactory.builder().connectString(config.getConnectionString()).retryPolicy((RetryPolicy)new ExponentialBackoffRetry(1000, 3)).aclProvider((ACLProvider)aclProvider).build();
        client.start();
        return new ClientAdapter(client, config);
    }

    private void configureSasl(RemoteConfigurationRegistryConfig config) {
        String registryName = config.getName();
        if (registryName == null) {
            registryName = DEFAULT_LOGIN_CONTEXT_NAME;
        }
        System.setProperty(LOGIN_CONTEXT_NAME_PROPERTY, registryName);
    }

    private static final class ZooKeeperACLAdapter
    implements RemoteConfigurationRegistryClient.EntryACL {
        private String type;
        private String id;
        private int permissions;

        ZooKeeperACLAdapter(ACL acl) {
            this.permissions = acl.getPerms();
            this.type = acl.getId().getScheme();
            this.id = acl.getId().getId();
        }

        public String getId() {
            return this.id;
        }

        public String getType() {
            return this.type;
        }

        public Object getPermissions() {
            return this.permissions;
        }

        public boolean canRead() {
            return this.permissions >= 1;
        }

        public boolean canWrite() {
            return this.permissions >= 2;
        }
    }

    private static final class EntryListenerAdapter
    implements NodeCacheListener {
        private RemoteConfigurationRegistryClient client;
        private RemoteConfigurationRegistryClient.EntryListener delegate;
        private NodeCache nodeCache;

        EntryListenerAdapter(RemoteConfigurationRegistryClient client, NodeCache nodeCache, RemoteConfigurationRegistryClient.EntryListener delegate) {
            this.client = client;
            this.nodeCache = nodeCache;
            this.delegate = delegate;
        }

        public void nodeChanged() throws Exception {
            String path = null;
            byte[] data = null;
            ChildData cd = this.nodeCache.getCurrentData();
            if (cd != null) {
                path = cd.getPath();
                data = cd.getData();
            }
            if (path != null) {
                this.delegate.entryChanged(this.client, path, data);
            }
        }
    }

    private static final class ChildEntryListenerAdapter
    implements PathChildrenCacheListener {
        private RemoteConfigurationRegistryClient client;
        private RemoteConfigurationRegistryClient.ChildEntryListener delegate;

        ChildEntryListenerAdapter(RemoteConfigurationRegistryClient client, RemoteConfigurationRegistryClient.ChildEntryListener delegate) {
            this.client = client;
            this.delegate = delegate;
        }

        public void childEvent(CuratorFramework curatorFramework, PathChildrenCacheEvent pathChildrenCacheEvent) throws Exception {
            RemoteConfigurationRegistryClient.ChildEntryListener.Type eventType;
            ChildData childData = pathChildrenCacheEvent.getData();
            if (childData != null && (eventType = this.adaptType(pathChildrenCacheEvent.getType())) != null) {
                this.delegate.childEvent(this.client, eventType, childData.getPath());
            }
        }

        private RemoteConfigurationRegistryClient.ChildEntryListener.Type adaptType(PathChildrenCacheEvent.Type type) {
            RemoteConfigurationRegistryClient.ChildEntryListener.Type adapted = null;
            switch (type) {
                case CHILD_ADDED: {
                    adapted = RemoteConfigurationRegistryClient.ChildEntryListener.Type.ADDED;
                    break;
                }
                case CHILD_REMOVED: {
                    adapted = RemoteConfigurationRegistryClient.ChildEntryListener.Type.REMOVED;
                    break;
                }
                case CHILD_UPDATED: {
                    adapted = RemoteConfigurationRegistryClient.ChildEntryListener.Type.UPDATED;
                }
            }
            return adapted;
        }
    }

    private static class SASLOwnerACLProvider
    implements ACLProvider {
        private final List<ACL> saslACL = ZooDefs.Ids.CREATOR_ALL_ACL;

        SASLOwnerACLProvider() {
        }

        public List<ACL> getDefaultAcl() {
            return this.saslACL;
        }

        public List<ACL> getAclForPath(String path) {
            return this.getDefaultAcl();
        }
    }

    private static final class ClientAdapter
    implements RemoteConfigurationRegistryClient {
        private CuratorFramework delegate;
        private RemoteConfigurationRegistryConfig config;
        private Map<String, NodeCache> entryNodeCaches = new HashMap<String, NodeCache>();

        ClientAdapter(CuratorFramework delegate, RemoteConfigurationRegistryConfig config) {
            this.delegate = delegate;
            this.config = config;
        }

        public String getAddress() {
            return this.config.getConnectionString();
        }

        public boolean isAuthenticationConfigured() {
            return this.config.isSecureRegistry();
        }

        public boolean entryExists(String path) {
            Stat s = null;
            try {
                s = (Stat)this.delegate.checkExists().forPath(path);
            }
            catch (Exception exception) {
                // empty catch block
            }
            return s != null;
        }

        public List<RemoteConfigurationRegistryClient.EntryACL> getACL(String path) {
            ArrayList<RemoteConfigurationRegistryClient.EntryACL> acl = new ArrayList<RemoteConfigurationRegistryClient.EntryACL>();
            try {
                List zkACL = (List)this.delegate.getACL().forPath(path);
                if (zkACL != null) {
                    for (ACL aclEntry : zkACL) {
                        ZooKeeperACLAdapter entryACL = new ZooKeeperACLAdapter(aclEntry);
                        acl.add(entryACL);
                    }
                }
            }
            catch (Exception e) {
                log.errorHandlingRemoteConfigACL(path, e);
            }
            return acl;
        }

        public void setACL(String path, List<RemoteConfigurationRegistryClient.EntryACL> entryACLs) {
            ArrayList<ACL> delegateACLs = new ArrayList<ACL>();
            for (RemoteConfigurationRegistryClient.EntryACL entryACL : entryACLs) {
                String scheme = entryACL.getType();
                String id = entryACL.getId();
                int permissions = 0;
                if (entryACL.canWrite()) {
                    permissions = 31;
                } else if (entryACL.canRead()) {
                    permissions = 1;
                }
                delegateACLs.add(new ACL(permissions, new Id(scheme, id)));
            }
            try {
                ((BackgroundPathable)this.delegate.setACL().withACL(delegateACLs)).forPath(path);
            }
            catch (Exception e) {
                log.errorSettingEntryACL(path, e);
            }
        }

        public List<String> listChildEntries(String path) {
            List result = null;
            try {
                result = (List)this.delegate.getChildren().forPath(path);
            }
            catch (Exception e) {
                log.errorInteractingWithRemoteConfigRegistry(e);
            }
            return result;
        }

        public void addChildEntryListener(String path, RemoteConfigurationRegistryClient.ChildEntryListener listener) throws Exception {
            PathChildrenCache childCache = new PathChildrenCache(this.delegate, path, false);
            childCache.getListenable().addListener((Object)new ChildEntryListenerAdapter(this, listener));
            childCache.start();
        }

        public void addEntryListener(String path, RemoteConfigurationRegistryClient.EntryListener listener) throws Exception {
            NodeCache nodeCache = new NodeCache(this.delegate, path);
            nodeCache.getListenable().addListener((Object)new EntryListenerAdapter(this, nodeCache, listener));
            nodeCache.start();
            this.entryNodeCaches.put(path, nodeCache);
        }

        public void removeEntryListener(String path) throws Exception {
            NodeCache nodeCache = this.entryNodeCaches.remove(path);
            if (nodeCache != null) {
                nodeCache.close();
            }
        }

        public String getEntryData(String path) {
            return this.getEntryData(path, StandardCharsets.UTF_8.name());
        }

        public String getEntryData(String path, String encoding) {
            String result = null;
            try {
                byte[] data = (byte[])this.delegate.getData().forPath(path);
                if (data != null) {
                    result = new String(data, Charset.forName(encoding));
                }
            }
            catch (Exception e) {
                log.errorInteractingWithRemoteConfigRegistry(e);
            }
            return result;
        }

        public void createEntry(String path) {
            this.createEntry(path, null);
        }

        public void createEntry(String path, String data) {
            this.createEntry(path, data, StandardCharsets.UTF_8.name());
        }

        public void createEntry(String path, String data, String encoding) {
            try {
                byte[] dataBytes = data == null ? new byte[]{} : data.getBytes(encoding);
                if (this.delegate.checkExists().forPath(path) == null) {
                    this.delegate.create().forPath(path, dataBytes);
                }
            }
            catch (Exception e) {
                log.errorInteractingWithRemoteConfigRegistry(e);
            }
        }

        public int setEntryData(String path, String data) {
            return this.setEntryData(path, data, StandardCharsets.UTF_8.name());
        }

        public int setEntryData(String path, String data, String encoding) {
            int version = 0;
            try {
                Stat s = (Stat)this.delegate.setData().forPath(path, data.getBytes(Charset.forName(encoding)));
                if (s != null) {
                    version = s.getVersion();
                }
            }
            catch (Exception e) {
                log.errorInteractingWithRemoteConfigRegistry(e);
            }
            return version;
        }

        public void deleteEntry(String path) {
            try {
                this.delegate.delete().forPath(path);
            }
            catch (Exception e) {
                log.errorInteractingWithRemoteConfigRegistry(e);
            }
        }

        public void close() throws Exception {
            this.delegate.close();
        }
    }
}

