/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.topology;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.knox.gateway.service.definition.CustomDispatch;
import org.apache.knox.gateway.topology.Param;
import org.apache.knox.gateway.topology.Version;

public class Service {
    public static final String HA_ENABLED_PARAM = "haEnabled";
    private String role;
    private String name;
    private Version version;
    private Map<String, String> params = new LinkedHashMap<String, String>();
    private List<String> urls;
    private CustomDispatch dispatch;

    public String getRole() {
        return this.role;
    }

    public void setRole(String role) {
        this.role = role;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Version getVersion() {
        return this.version;
    }

    public void setVersion(Version version) {
        this.version = version;
    }

    public List<String> getUrls() {
        if (this.urls == null) {
            this.urls = new ArrayList<String>();
        }
        return this.urls;
    }

    public void setUrls(List<String> urls) {
        this.urls = urls;
    }

    public String getUrl() {
        if (!this.getUrls().isEmpty()) {
            return this.getUrls().get(0);
        }
        return null;
    }

    public void addUrl(String url) {
        this.getUrls().add(url);
    }

    public Map<String, String> getParams() {
        return this.params;
    }

    public Collection<Param> getParamsList() {
        ArrayList<Param> paramList = new ArrayList<Param>();
        for (Map.Entry<String, String> entry : this.params.entrySet()) {
            Param p = new Param();
            p.setName(entry.getKey());
            p.setValue(entry.getValue());
            paramList.add(p);
        }
        return paramList;
    }

    public void setParamsList(Collection<Param> params) {
        if (params != null) {
            for (Param param : params) {
                this.addParam(param);
            }
        }
    }

    public void setParams(Map<String, String> params) {
        this.params = params;
    }

    public void addParam(Param param) {
        this.params.put(param.getName(), param.getValue());
    }

    public boolean equals(Object object) {
        if (!(object instanceof Service)) {
            return false;
        }
        Service that = (Service)object;
        String thatName = that.getName();
        if (thatName != null && !thatName.equals(this.name)) {
            return false;
        }
        String thatRole = that.getRole();
        if (thatRole != null && !thatRole.equals(this.role)) {
            return false;
        }
        Version thatVersion = that.getVersion();
        return thatVersion == null || thatVersion.equals(this.version);
    }

    public int hashCode() {
        int hashCode = 17;
        if (this.getName() != null) {
            hashCode *= 31 * this.getName().hashCode();
        }
        if (this.getRole() != null) {
            hashCode *= 31 * this.getRole().hashCode();
        }
        if (this.getVersion() != null) {
            hashCode *= 31 * this.getVersion().hashCode();
        }
        return hashCode;
    }

    public CustomDispatch getDispatch() {
        return this.dispatch;
    }

    public void addDispatch(CustomDispatch dispatch) {
        this.dispatch = dispatch;
    }
}

