/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.vault.support;

import java.util.Arrays;
import org.springframework.util.Assert;

public class VaultToken {
    private final char[] token;

    protected VaultToken(char[] token) {
        Assert.notNull((Object)token, (String)"Token must not be null");
        Assert.isTrue((token.length > 0 ? 1 : 0) != 0, (String)"Token must not be empty");
        this.token = Arrays.copyOf(token, token.length);
    }

    public static VaultToken of(String token) {
        Assert.hasText((String)token, (String)"Token must not be empty");
        return VaultToken.of(token.toCharArray());
    }

    public static VaultToken of(char[] token) {
        return new VaultToken(token);
    }

    public String getToken() {
        return new String(this.token);
    }

    public char[] toCharArray() {
        return this.token;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof VaultToken)) {
            return false;
        }
        VaultToken other = (VaultToken)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$token = this.getToken();
        String other$token = other.getToken();
        return !(this$token == null ? other$token != null : !this$token.equals(other$token));
    }

    protected boolean canEqual(Object other) {
        return other instanceof VaultToken;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $token = this.getToken();
        result = result * 59 + ($token == null ? 43 : $token.hashCode());
        return result;
    }

    public String toString() {
        return "VaultToken()";
    }
}

