/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.api.swagger.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ApiModel(description="Arguments used for Disable NameNode High Availability command.")
public class ApiDisableNnHaArguments {
    @SerializedName(value="activeNnName")
    private String activeNnName = null;
    @SerializedName(value="snnHostId")
    private String snnHostId = null;
    @SerializedName(value="snnCheckpointDirList")
    private List<String> snnCheckpointDirList = null;
    @SerializedName(value="snnName")
    private String snnName = null;

    public ApiDisableNnHaArguments activeNnName(String activeNnName) {
        this.activeNnName = activeNnName;
        return this;
    }

    @ApiModelProperty(value="Name of the NamdeNode role that is going to be active after High Availability is disabled.")
    public String getActiveNnName() {
        return this.activeNnName;
    }

    public void setActiveNnName(String activeNnName) {
        this.activeNnName = activeNnName;
    }

    public ApiDisableNnHaArguments snnHostId(String snnHostId) {
        this.snnHostId = snnHostId;
        return this;
    }

    @ApiModelProperty(value="Id of the host where the new SecondaryNameNode will be created.")
    public String getSnnHostId() {
        return this.snnHostId;
    }

    public void setSnnHostId(String snnHostId) {
        this.snnHostId = snnHostId;
    }

    public ApiDisableNnHaArguments snnCheckpointDirList(List<String> snnCheckpointDirList) {
        this.snnCheckpointDirList = snnCheckpointDirList;
        return this;
    }

    public ApiDisableNnHaArguments addSnnCheckpointDirListItem(String snnCheckpointDirListItem) {
        if (this.snnCheckpointDirList == null) {
            this.snnCheckpointDirList = new ArrayList<String>();
        }
        this.snnCheckpointDirList.add(snnCheckpointDirListItem);
        return this;
    }

    @ApiModelProperty(example="\"null\"", value="List of directories used for checkpointing by the new SecondaryNameNode.")
    public List<String> getSnnCheckpointDirList() {
        return this.snnCheckpointDirList;
    }

    public void setSnnCheckpointDirList(List<String> snnCheckpointDirList) {
        this.snnCheckpointDirList = snnCheckpointDirList;
    }

    public ApiDisableNnHaArguments snnName(String snnName) {
        this.snnName = snnName;
        return this;
    }

    @ApiModelProperty(value="Name of the new SecondaryNameNode role (Optional).")
    public String getSnnName() {
        return this.snnName;
    }

    public void setSnnName(String snnName) {
        this.snnName = snnName;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ApiDisableNnHaArguments apiDisableNnHaArguments = (ApiDisableNnHaArguments)o;
        return Objects.equals(this.activeNnName, apiDisableNnHaArguments.activeNnName) && Objects.equals(this.snnHostId, apiDisableNnHaArguments.snnHostId) && Objects.equals(this.snnCheckpointDirList, apiDisableNnHaArguments.snnCheckpointDirList) && Objects.equals(this.snnName, apiDisableNnHaArguments.snnName);
    }

    public int hashCode() {
        return Objects.hash(this.activeNnName, this.snnHostId, this.snnCheckpointDirList, this.snnName);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ApiDisableNnHaArguments {\n");
        sb.append("    activeNnName: ").append(this.toIndentedString(this.activeNnName)).append("\n");
        sb.append("    snnHostId: ").append(this.toIndentedString(this.snnHostId)).append("\n");
        sb.append("    snnCheckpointDirList: ").append(this.toIndentedString(this.snnCheckpointDirList)).append("\n");
        sb.append("    snnName: ").append(this.toIndentedString(this.snnName)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

