/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.api.swagger.model;

import com.cloudera.api.swagger.model.ApiClusterRef;
import com.cloudera.api.swagger.model.ApiParcelState;
import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@ApiModel(description="A Parcel encapsulate a specific product and version. For example, (CDH 4.1). A parcel is downloaded, distributed to all the machines of a cluster and then allowed to be activated. <p>> The available parcels are determined by which cluster they will be running on. For example, a SLES parcel won't show up for a RHEL cluster. </p>")
public class ApiParcel {
    @SerializedName(value="product")
    private String product = null;
    @SerializedName(value="version")
    private String version = null;
    @SerializedName(value="stage")
    private String stage = null;
    @SerializedName(value="state")
    private ApiParcelState state = null;
    @SerializedName(value="clusterRef")
    private ApiClusterRef clusterRef = null;

    public ApiParcel product(String product) {
        this.product = product;
        return this;
    }

    @ApiModelProperty(value="The name of the product, e.g. CDH, Impala")
    public String getProduct() {
        return this.product;
    }

    public void setProduct(String product) {
        this.product = product;
    }

    public ApiParcel version(String version) {
        this.version = version;
        return this;
    }

    @ApiModelProperty(value="The version of the product, e.g. 1.1.0, 2.3.0.")
    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public ApiParcel stage(String stage) {
        this.stage = stage;
        return this;
    }

    @ApiModelProperty(value="Returns the current stage of the parcel. <p> There are a number of stages a parcel can be in. There are two types of stages - stable and transient. A parcel is in a transient stage when it is transitioning between two stable stages. The stages are listed below with some additional information.  <ul> <li><b>AVAILABLE_REMOTELY</b>: Stable stage - the parcel can be downloaded to the server.</li> <li><b>DOWNLOADING</b>: Transient stage - the parcel is in the process of being downloaded to the server.</li> <li><b>DOWNLOADED</b>: Stable stage - the parcel is downloaded and ready to be distributed or removed from the server.</li> <li><b>DISTRIBUTING</b>: Transient stage - the parcel is being sent to all the hosts in the cluster.</li> <li><b>DISTRIBUTED</b>: Stable stage - the parcel is on all the hosts in the cluster. The parcel can now be activated, or removed from all the hosts.</li> <li><b>UNDISTRIBUTING</b>: Transient stage - the parcel is being removed from all the hosts in the cluster></li> <li><b>ACTIVATING</b>: Transient stage - the parcel is being activated on the hosts in the cluster. <i>New in API v7</i></li> <li><b>ACTIVATED</b>: Steady stage - the parcel is set to active on every host in the cluster. If desired, a parcel can be deactivated from this stage.</li> </ul>")
    public String getStage() {
        return this.stage;
    }

    public void setStage(String stage) {
        this.stage = stage;
    }

    public ApiParcel state(ApiParcelState state) {
        this.state = state;
        return this;
    }

    @ApiModelProperty(value="The state of the parcel. This shows the progress of state transitions and if there were any errors.")
    public ApiParcelState getState() {
        return this.state;
    }

    public void setState(ApiParcelState state) {
        this.state = state;
    }

    public ApiParcel clusterRef(ApiClusterRef clusterRef) {
        this.clusterRef = clusterRef;
        return this;
    }

    @ApiModelProperty(value="Readonly. A reference to the enclosing cluster.")
    public ApiClusterRef getClusterRef() {
        return this.clusterRef;
    }

    public void setClusterRef(ApiClusterRef clusterRef) {
        this.clusterRef = clusterRef;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ApiParcel apiParcel = (ApiParcel)o;
        return Objects.equals(this.product, apiParcel.product) && Objects.equals(this.version, apiParcel.version) && Objects.equals(this.stage, apiParcel.stage) && Objects.equals(this.state, apiParcel.state) && Objects.equals(this.clusterRef, apiParcel.clusterRef);
    }

    public int hashCode() {
        return Objects.hash(this.product, this.version, this.stage, this.state, this.clusterRef);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ApiParcel {\n");
        sb.append("    product: ").append(this.toIndentedString(this.product)).append("\n");
        sb.append("    version: ").append(this.toIndentedString(this.version)).append("\n");
        sb.append("    stage: ").append(this.toIndentedString(this.stage)).append("\n");
        sb.append("    state: ").append(this.toIndentedString(this.state)).append("\n");
        sb.append("    clusterRef: ").append(this.toIndentedString(this.clusterRef)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

