/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.api.swagger.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.math.BigDecimal;
import java.util.Objects;

@ApiModel(description="A class holding additional metadata to the ApiTimeSeriesAggregateStatistics class that applies specifically to cross-entity aggregate metrics.")
public class ApiTimeSeriesCrossEntityMetadata {
    @SerializedName(value="maxEntityDisplayName")
    private String maxEntityDisplayName = null;
    @SerializedName(value="maxEntityName")
    private String maxEntityName = null;
    @SerializedName(value="minEntityDisplayName")
    private String minEntityDisplayName = null;
    @SerializedName(value="minEntityName")
    private String minEntityName = null;
    @SerializedName(value="numEntities")
    private BigDecimal numEntities = null;

    public ApiTimeSeriesCrossEntityMetadata maxEntityDisplayName(String maxEntityDisplayName) {
        this.maxEntityDisplayName = maxEntityDisplayName;
        return this;
    }

    @ApiModelProperty(value="The display name of the entity that had the maximum value for the cross-entity aggregate metric.")
    public String getMaxEntityDisplayName() {
        return this.maxEntityDisplayName;
    }

    public void setMaxEntityDisplayName(String maxEntityDisplayName) {
        this.maxEntityDisplayName = maxEntityDisplayName;
    }

    public ApiTimeSeriesCrossEntityMetadata maxEntityName(String maxEntityName) {
        this.maxEntityName = maxEntityName;
        return this;
    }

    @ApiModelProperty(value="The name of the entity that had the maximum value for the cross-entity aggregate metric. <p> Available since API v11.")
    public String getMaxEntityName() {
        return this.maxEntityName;
    }

    public void setMaxEntityName(String maxEntityName) {
        this.maxEntityName = maxEntityName;
    }

    public ApiTimeSeriesCrossEntityMetadata minEntityDisplayName(String minEntityDisplayName) {
        this.minEntityDisplayName = minEntityDisplayName;
        return this;
    }

    @ApiModelProperty(value="The display name of the entity that had the minimum value for the cross-entity aggregate metric.")
    public String getMinEntityDisplayName() {
        return this.minEntityDisplayName;
    }

    public void setMinEntityDisplayName(String minEntityDisplayName) {
        this.minEntityDisplayName = minEntityDisplayName;
    }

    public ApiTimeSeriesCrossEntityMetadata minEntityName(String minEntityName) {
        this.minEntityName = minEntityName;
        return this;
    }

    @ApiModelProperty(value="The name of the entity that had the minimum value for the cross-entity aggregate metric. <p> Available since API v11.")
    public String getMinEntityName() {
        return this.minEntityName;
    }

    public void setMinEntityName(String minEntityName) {
        this.minEntityName = minEntityName;
    }

    public ApiTimeSeriesCrossEntityMetadata numEntities(BigDecimal numEntities) {
        this.numEntities = numEntities;
        return this;
    }

    @ApiModelProperty(value="The number of entities covered by this point. For a raw cross-entity point this number is exact. For a rollup point this number is an average, since the number of entities being aggregated can change over the aggregation period.")
    public BigDecimal getNumEntities() {
        return this.numEntities;
    }

    public void setNumEntities(BigDecimal numEntities) {
        this.numEntities = numEntities;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ApiTimeSeriesCrossEntityMetadata apiTimeSeriesCrossEntityMetadata = (ApiTimeSeriesCrossEntityMetadata)o;
        return Objects.equals(this.maxEntityDisplayName, apiTimeSeriesCrossEntityMetadata.maxEntityDisplayName) && Objects.equals(this.maxEntityName, apiTimeSeriesCrossEntityMetadata.maxEntityName) && Objects.equals(this.minEntityDisplayName, apiTimeSeriesCrossEntityMetadata.minEntityDisplayName) && Objects.equals(this.minEntityName, apiTimeSeriesCrossEntityMetadata.minEntityName) && Objects.equals(this.numEntities, apiTimeSeriesCrossEntityMetadata.numEntities);
    }

    public int hashCode() {
        return Objects.hash(this.maxEntityDisplayName, this.maxEntityName, this.minEntityDisplayName, this.minEntityName, this.numEntities);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ApiTimeSeriesCrossEntityMetadata {\n");
        sb.append("    maxEntityDisplayName: ").append(this.toIndentedString(this.maxEntityDisplayName)).append("\n");
        sb.append("    maxEntityName: ").append(this.toIndentedString(this.maxEntityName)).append("\n");
        sb.append("    minEntityDisplayName: ").append(this.toIndentedString(this.minEntityDisplayName)).append("\n");
        sb.append("    minEntityName: ").append(this.toIndentedString(this.minEntityName)).append("\n");
        sb.append("    numEntities: ").append(this.toIndentedString(this.numEntities)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

