/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.ldap.handlers.request;

import org.apache.directory.api.ldap.model.message.AddRequest;
import org.apache.directory.api.ldap.model.message.LdapResult;
import org.apache.directory.api.ldap.model.message.ResultCodeEnum;
import org.apache.directory.api.ldap.model.message.ResultResponseRequest;
import org.apache.directory.server.core.api.CoreSession;
import org.apache.directory.server.ldap.LdapSession;
import org.apache.directory.server.ldap.handlers.LdapRequestHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AddRequestHandler
extends LdapRequestHandler<AddRequest> {
    private static final Logger LOG = LoggerFactory.getLogger(AddRequestHandler.class);

    @Override
    public void handle(LdapSession session, AddRequest req) {
        LOG.debug("Handling request: {}", (Object)req);
        LdapResult result = req.getResultResponse().getLdapResult();
        try {
            CoreSession coreSession = session.getCoreSession();
            coreSession.add(req);
            result.setResultCode(ResultCodeEnum.SUCCESS);
            session.getIoSession().write((Object)req.getResultResponse());
        }
        catch (Exception e) {
            this.handleException(session, (ResultResponseRequest)req, e);
        }
    }
}

