/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.codec.actions.request.search;

import org.apache.directory.api.asn1.DecoderException;
import org.apache.directory.api.asn1.ber.grammar.GrammarAction;
import org.apache.directory.api.i18n.I18n;
import org.apache.directory.api.ldap.codec.api.LdapMessageContainer;
import org.apache.directory.api.ldap.codec.decorators.SearchRequestDecorator;
import org.apache.directory.api.ldap.model.exception.LdapSchemaException;
import org.apache.directory.api.ldap.model.message.SearchRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InitSearchRequestAttributeDescList
extends GrammarAction<LdapMessageContainer<SearchRequestDecorator>> {
    private static final Logger LOG = LoggerFactory.getLogger(InitSearchRequestAttributeDescList.class);

    public InitSearchRequestAttributeDescList() {
        super("Initialize AttributeDesc list");
    }

    public void action(LdapMessageContainer<SearchRequestDecorator> container) throws DecoderException {
        SearchRequestDecorator searchRequestDecorator = container.getMessage();
        SearchRequest searchRequest = (SearchRequest)searchRequestDecorator.getDecorated();
        try {
            searchRequest.setFilter(searchRequestDecorator.getFilterNode());
        }
        catch (LdapSchemaException lse) {
            throw new DecoderException(lse.getMessage(), (Throwable)lse);
        }
        container.setGrammarEndAllowed(true);
        if (LOG.isDebugEnabled()) {
            LOG.debug(I18n.msg((I18n)I18n.MSG_05158_INITIALIZE_ATT_DESC_LIST, (Object[])new Object[0]));
        }
    }
}

