/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.codec.actions.request.search;

import org.apache.directory.api.asn1.DecoderException;
import org.apache.directory.api.asn1.ber.grammar.GrammarAction;
import org.apache.directory.api.asn1.ber.tlv.BerValue;
import org.apache.directory.api.asn1.ber.tlv.LongDecoder;
import org.apache.directory.api.asn1.ber.tlv.LongDecoderException;
import org.apache.directory.api.asn1.ber.tlv.TLV;
import org.apache.directory.api.i18n.I18n;
import org.apache.directory.api.ldap.codec.api.LdapMessageContainer;
import org.apache.directory.api.ldap.codec.decorators.SearchRequestDecorator;
import org.apache.directory.api.ldap.model.message.SearchRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StoreSearchRequestSizeLimit
extends GrammarAction<LdapMessageContainer<SearchRequestDecorator>> {
    private static final Logger LOG = LoggerFactory.getLogger(StoreSearchRequestSizeLimit.class);

    public StoreSearchRequestSizeLimit() {
        super("Store SearchRequest sizeLimit");
    }

    public void action(LdapMessageContainer<SearchRequestDecorator> container) throws DecoderException {
        SearchRequest searchRequest = (SearchRequest)container.getMessage().getDecorated();
        TLV tlv = container.getCurrentTLV();
        BerValue value = tlv.getValue();
        long sizeLimit = 0L;
        try {
            sizeLimit = LongDecoder.parse((BerValue)value, (long)0L, (long)Integer.MAX_VALUE);
        }
        catch (LongDecoderException lde) {
            String msg = I18n.err((I18n)I18n.ERR_05151_BAD_SIZE_LIMIT, (Object[])new Object[]{value.toString()});
            LOG.error(msg);
            throw new DecoderException(msg, (Throwable)lde);
        }
        searchRequest.setSizeLimit(sizeLimit);
        if (LOG.isDebugEnabled()) {
            LOG.debug(I18n.msg((I18n)I18n.MSG_05163_SIZE_LIMIT_SET_TO, (Object[])new Object[]{sizeLimit}));
        }
    }
}

