/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.codec.actions.request.search.filter;

import org.apache.directory.api.asn1.ber.Asn1Container;
import org.apache.directory.api.asn1.ber.grammar.GrammarAction;
import org.apache.directory.api.asn1.ber.tlv.TLV;
import org.apache.directory.api.i18n.I18n;
import org.apache.directory.api.ldap.codec.AttributeValueAssertion;
import org.apache.directory.api.ldap.codec.api.LdapMessageContainer;
import org.apache.directory.api.ldap.codec.decorators.SearchRequestDecorator;
import org.apache.directory.api.ldap.codec.search.AttributeValueAssertionFilter;
import org.apache.directory.api.util.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InitAssertionValueFilter
extends GrammarAction<LdapMessageContainer<SearchRequestDecorator>> {
    private static final Logger LOG = LoggerFactory.getLogger(InitAssertionValueFilter.class);

    public InitAssertionValueFilter() {
        super("Initialize Assertion Value filter");
    }

    public void action(LdapMessageContainer<SearchRequestDecorator> container) {
        SearchRequestDecorator searchRequestDecorator = container.getMessage();
        TLV tlv = container.getCurrentTLV();
        byte[] assertion = tlv.getValue().getData();
        AttributeValueAssertionFilter terminalFilter = (AttributeValueAssertionFilter)searchRequestDecorator.getTerminalFilter();
        AttributeValueAssertion attributeValueAssertion = terminalFilter.getAssertion();
        if (assertion == null) {
            attributeValueAssertion.setAssertion(Strings.EMPTY_BYTES);
        } else {
            attributeValueAssertion.setAssertion(assertion);
        }
        searchRequestDecorator.unstackFilters((Asn1Container)container);
        if (LOG.isDebugEnabled()) {
            LOG.debug(I18n.msg((I18n)I18n.MSG_05144_INITIALIZE_ASSERTION_FILTER, (Object[])new Object[0]));
        }
    }
}

