/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.util;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Set;
import java.util.TreeSet;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.TrueFileFilter;
import org.apache.knox.gateway.GatewayMessages;
import org.apache.knox.gateway.deploy.ServiceDeploymentContributor;
import org.apache.knox.gateway.deploy.impl.ServiceDefinitionDeploymentContributor;
import org.apache.knox.gateway.filter.rewrite.api.UrlRewriteRulesDescriptor;
import org.apache.knox.gateway.filter.rewrite.api.UrlRewriteRulesDescriptorFactory;
import org.apache.knox.gateway.i18n.messages.MessagesFactory;
import org.apache.knox.gateway.service.definition.ServiceDefinition;
import org.apache.knox.gateway.service.definition.ServiceDefinitionComparator;
import org.apache.knox.gateway.service.definition.ServiceDefinitionPair;
import org.apache.knox.gateway.service.definition.ServiceDefinitionPairComparator;

public class ServiceDefinitionsLoader {
    private static final JAXBContext jaxbContext = ServiceDefinitionsLoader.getJAXBContext();
    private static final GatewayMessages log = (GatewayMessages)MessagesFactory.get(GatewayMessages.class);
    private static final String SERVICE_FILE_NAME = "service";
    private static final String REWRITE_FILE = "rewrite.xml";

    private static JAXBContext getJAXBContext() {
        try {
            return JAXBContext.newInstance((Class[])new Class[]{ServiceDefinition.class});
        }
        catch (JAXBException e) {
            throw new IllegalStateException(e);
        }
    }

    private static Unmarshaller createUnmarshaller() {
        try {
            return jaxbContext.createUnmarshaller();
        }
        catch (JAXBException e) {
            throw new RuntimeException("Could not create unmarshaller", e);
        }
    }

    public static Set<ServiceDeploymentContributor> loadServiceDefinitionDeploymentContributors(File servicesDir) {
        HashSet<ServiceDeploymentContributor> contributors = new HashSet<ServiceDeploymentContributor>();
        ServiceDefinitionsLoader.loadServiceDefinitions(servicesDir).forEach(serviceDefinitionPair -> contributors.add((ServiceDeploymentContributor)new ServiceDefinitionDeploymentContributor(serviceDefinitionPair.getService(), serviceDefinitionPair.getRewriteRules())));
        return contributors;
    }

    public static Set<ServiceDefinitionPair> loadServiceDefinitions(File servicesDir) {
        TreeSet<ServiceDefinitionPair> serviceDefinitions = new TreeSet<ServiceDefinitionPair>((Comparator<ServiceDefinitionPair>)new ServiceDefinitionPairComparator());
        if (servicesDir.exists() && servicesDir.isDirectory()) {
            Unmarshaller unmarshaller = ServiceDefinitionsLoader.createUnmarshaller();
            ServiceDefinitionsLoader.getFileList(servicesDir).forEach(serviceFile -> {
                try {
                    serviceDefinitions.add(ServiceDefinitionsLoader.loadServiceDefinition(unmarshaller, serviceFile));
                }
                catch (FileNotFoundException e) {
                    log.failedToFindServiceDefinitionFile(serviceFile.getAbsolutePath(), e);
                }
                catch (IOException | JAXBException e) {
                    log.failedToLoadServiceDefinition(serviceFile.getAbsolutePath(), (Exception)e);
                }
            });
        }
        return serviceDefinitions;
    }

    private static ServiceDefinitionPair loadServiceDefinition(Unmarshaller unmarshaller, File serviceFile) throws IOException, JAXBException {
        try (InputStream inputStream = Files.newInputStream(serviceFile.toPath(), new OpenOption[0]);){
            ServiceDefinition service = (ServiceDefinition)unmarshaller.unmarshal(serviceFile);
            UrlRewriteRulesDescriptor rewriteRules = ServiceDefinitionsLoader.loadRewriteRules(serviceFile.getParentFile());
            ServiceDefinitionPair serviceDefinitionPair = new ServiceDefinitionPair(service, rewriteRules);
            return serviceDefinitionPair;
        }
    }

    public static Set<ServiceDefinition> getServiceDefinitions(File servicesDir) {
        TreeSet<ServiceDefinition> services = new TreeSet<ServiceDefinition>((Comparator<ServiceDefinition>)new ServiceDefinitionComparator());
        ServiceDefinitionsLoader.loadServiceDefinitions(servicesDir).forEach(serviceDefinitionPair -> services.add(serviceDefinitionPair.getService()));
        return services;
    }

    private static Collection<File> getFileList(File servicesDir) {
        Collection<File> files = servicesDir.exists() && servicesDir.isDirectory() ? FileUtils.listFiles((File)servicesDir, (IOFileFilter)new IOFileFilter(){

            public boolean accept(File file) {
                return this.acceptName(file.getName());
            }

            public boolean accept(File dir, String name) {
                return this.acceptName(name);
            }

            private boolean acceptName(String name) {
                return name.contains(ServiceDefinitionsLoader.SERVICE_FILE_NAME) && !name.startsWith(".") && name.endsWith(".xml");
            }
        }, (IOFileFilter)TrueFileFilter.INSTANCE) : new HashSet<File>();
        return files;
    }

    /*
     * Loose catch block
     */
    public static UrlRewriteRulesDescriptor loadRewriteRules(File servicesDir) {
        File rewriteFile = new File(servicesDir, REWRITE_FILE);
        if (rewriteFile.exists()) {
            UrlRewriteRulesDescriptor urlRewriteRulesDescriptor;
            Throwable throwable;
            InputStreamReader reader;
            Throwable throwable2;
            InputStream stream;
            block15: {
                stream = Files.newInputStream(rewriteFile.toPath(), new OpenOption[0]);
                throwable2 = null;
                reader = new InputStreamReader(stream, StandardCharsets.UTF_8);
                throwable = null;
                urlRewriteRulesDescriptor = UrlRewriteRulesDescriptorFactory.load((String)"xml", (Reader)reader);
                ServiceDefinitionsLoader.$closeResource(throwable, reader);
                if (stream == null) break block15;
                ServiceDefinitionsLoader.$closeResource(throwable2, stream);
            }
            return urlRewriteRulesDescriptor;
            {
                catch (Throwable throwable3) {
                    try {
                        try {
                            try {
                                try {
                                    throwable = throwable3;
                                    throw throwable3;
                                }
                                catch (Throwable throwable4) {
                                    ServiceDefinitionsLoader.$closeResource(throwable, reader);
                                    throw throwable4;
                                }
                            }
                            catch (Throwable throwable5) {
                                throwable2 = throwable5;
                                throw throwable5;
                            }
                        }
                        catch (Throwable throwable6) {
                            if (stream != null) {
                                ServiceDefinitionsLoader.$closeResource(throwable2, stream);
                            }
                            throw throwable6;
                        }
                    }
                    catch (FileNotFoundException e) {
                        log.failedToFindRewriteFile(rewriteFile.getAbsolutePath(), e);
                    }
                    catch (IOException e) {
                        log.failedToLoadRewriteFile(rewriteFile.getAbsolutePath(), e);
                    }
                }
            }
        }
        log.noRewriteFileFound(servicesDir.getAbsolutePath());
        return null;
    }
}

