/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.audit.log4j.correlation;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.util.concurrent.Callable;
import org.apache.knox.gateway.audit.api.CorrelationContext;
import org.apache.knox.gateway.audit.api.CorrelationService;
import org.apache.knox.gateway.audit.log4j.correlation.Log4jCorrelationContext;
import org.apache.log4j.MDC;

public class Log4jCorrelationService
implements CorrelationService {
    public static final String MDC_CORRELATION_CONTEXT_KEY = "correlation_context";

    @Override
    public CorrelationContext createContext() {
        CorrelationContext context = this.getContext();
        if (context == null) {
            context = new Log4jCorrelationContext();
            this.attachContext(context);
        }
        return context;
    }

    @Override
    public CorrelationContext getContext() {
        return (CorrelationContext)MDC.get((String)MDC_CORRELATION_CONTEXT_KEY);
    }

    @Override
    public void attachContext(CorrelationContext context) {
        if (context != null) {
            MDC.put((String)MDC_CORRELATION_CONTEXT_KEY, (Object)context);
        }
    }

    @Override
    public CorrelationContext detachContext() {
        CorrelationContext context = (CorrelationContext)MDC.get((String)MDC_CORRELATION_CONTEXT_KEY);
        MDC.remove((String)MDC_CORRELATION_CONTEXT_KEY);
        return context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T execute(CorrelationContext context, Callable<T> callable) throws Exception {
        try {
            this.attachContext(context);
            T t = callable.call();
            return t;
        }
        finally {
            this.detachContext();
        }
    }

    @Override
    public CorrelationContext attachExternalizedContext(byte[] externalizedContext) {
        CorrelationContext context = this.readExternalizedContext(externalizedContext);
        this.attachContext(context);
        return context;
    }

    @Override
    public byte[] detachExternalizedContext() {
        byte[] result = this.getExternalizedContext();
        this.detachContext();
        return result;
    }

    /*
     * Exception decompiling
     */
    @Override
    public CorrelationContext readExternalizedContext(byte[] externalizedContext) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public byte[] getExternalizedContext() {
        byte[] byArray;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        Throwable throwable = null;
        try {
            try (ObjectOutputStream oos = new ObjectOutputStream(baos);){
                oos.writeObject(this.getContext());
            }
            byArray = baos.toByteArray();
        }
        catch (Throwable throwable2) {
            try {
                try {
                    throwable = throwable2;
                    throw throwable2;
                }
                catch (Throwable throwable3) {
                    Log4jCorrelationService.$closeResource(throwable, baos);
                    throw throwable3;
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        Log4jCorrelationService.$closeResource(throwable, baos);
        return byArray;
    }
}

