/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.oauth.client;

import org.pac4j.core.logout.CasLogoutActionBuilder;
import org.pac4j.core.logout.LogoutActionBuilder;
import org.pac4j.core.util.CommonHelper;
import org.pac4j.oauth.client.OAuth20Client;
import org.pac4j.oauth.profile.casoauthwrapper.CasOAuthWrapperProfile;
import org.pac4j.oauth.profile.casoauthwrapper.CasOAuthWrapperProfileDefinition;
import org.pac4j.scribe.builder.api.CasOAuthWrapperApi20;

public class CasOAuthWrapperClient
extends OAuth20Client<CasOAuthWrapperProfile> {
    private String casOAuthUrl;
    private String casLogoutUrl;
    private boolean springSecurityCompliant = false;
    private boolean implicitFlow = false;

    public CasOAuthWrapperClient() {
    }

    public CasOAuthWrapperClient(String key, String secret, String casOAuthUrl) {
        this.setKey(key);
        this.setSecret(secret);
        this.setCasOAuthUrl(casOAuthUrl);
    }

    @Override
    protected void clientInit() {
        CommonHelper.assertNotBlank((String)"casOAuthUrl", (String)this.casOAuthUrl);
        this.configuration.setApi(new CasOAuthWrapperApi20(this.casOAuthUrl, this.springSecurityCompliant));
        this.configuration.setProfileDefinition(new CasOAuthWrapperProfileDefinition());
        if (this.implicitFlow) {
            this.configuration.setResponseType("token");
        } else {
            this.configuration.setResponseType("code");
        }
        this.defaultLogoutActionBuilder((LogoutActionBuilder)new CasLogoutActionBuilder(this.casLogoutUrl, "service"));
        super.clientInit();
    }

    public String getCasOAuthUrl() {
        return this.casOAuthUrl;
    }

    public void setCasOAuthUrl(String casOAuthUrl) {
        CommonHelper.assertNotBlank((String)"casOAuthUrl", (String)casOAuthUrl);
        this.casOAuthUrl = casOAuthUrl.endsWith("/") ? casOAuthUrl.substring(0, casOAuthUrl.length() - 1) : casOAuthUrl;
    }

    public boolean isSpringSecurityCompliant() {
        return this.springSecurityCompliant;
    }

    public void setSpringSecurityCompliant(boolean springSecurityCompliant) {
        this.springSecurityCompliant = springSecurityCompliant;
    }

    public boolean isImplicitFlow() {
        return this.implicitFlow;
    }

    public void setImplicitFlow(boolean implicitFlow) {
        this.implicitFlow = implicitFlow;
    }

    public String getCasLogoutUrl() {
        return this.casLogoutUrl;
    }

    public void setCasLogoutUrl(String casLogoutUrl) {
        this.casLogoutUrl = casLogoutUrl;
    }
}

