/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.services.token.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.knox.gateway.config.GatewayConfig;
import org.apache.knox.gateway.services.ServiceLifecycleException;
import org.apache.knox.gateway.services.security.AliasService;
import org.apache.knox.gateway.services.security.AliasServiceException;
import org.apache.knox.gateway.services.security.token.UnknownTokenException;
import org.apache.knox.gateway.services.token.impl.DefaultTokenStateService;

public class AliasBasedTokenStateService
extends DefaultTokenStateService {
    private AliasService aliasService;
    private static final String TOKEN_MAX_LIFETIME_POSTFIX = "--max";

    public void setAliasService(AliasService aliasService) {
        this.aliasService = aliasService;
    }

    @Override
    public void init(GatewayConfig config, Map<String, String> options) throws ServiceLifecycleException {
        super.init(config, options);
        if (this.aliasService == null) {
            throw new ServiceLifecycleException("The required AliasService reference has not been set.");
        }
    }

    @Override
    public void addToken(String tokenId, long issueTime, long expiration, long maxLifetimeDuration) {
        this.isValidIdentifier(tokenId);
        try {
            this.aliasService.addAliasForCluster("__gateway", tokenId, String.valueOf(expiration));
            this.setMaxLifetime(tokenId, issueTime, maxLifetimeDuration);
            log.addedToken(tokenId, this.getTimestampDisplay(expiration));
        }
        catch (AliasServiceException e) {
            log.failedToSaveTokenState(tokenId, (Exception)((Object)e));
        }
    }

    @Override
    protected void setMaxLifetime(String tokenId, long issueTime, long maxLifetimeDuration) {
        try {
            this.aliasService.addAliasForCluster("__gateway", tokenId + TOKEN_MAX_LIFETIME_POSTFIX, String.valueOf(issueTime + maxLifetimeDuration));
        }
        catch (AliasServiceException e) {
            log.failedToSaveTokenState(tokenId, (Exception)((Object)e));
        }
    }

    @Override
    protected long getMaxLifetime(String tokenId) {
        long result = 0L;
        try {
            char[] maxLifetimeStr = this.aliasService.getPasswordFromAliasForCluster("__gateway", tokenId + TOKEN_MAX_LIFETIME_POSTFIX);
            if (maxLifetimeStr != null) {
                result = Long.parseLong(new String(maxLifetimeStr));
            }
        }
        catch (AliasServiceException e) {
            log.errorAccessingTokenState(tokenId, (Exception)((Object)e));
        }
        return result;
    }

    @Override
    public long getTokenExpiration(String tokenId) throws UnknownTokenException {
        long expiration = 0L;
        this.validateToken(tokenId);
        try {
            char[] expStr = this.aliasService.getPasswordFromAliasForCluster("__gateway", tokenId);
            if (expStr != null) {
                expiration = Long.parseLong(new String(expStr));
            }
        }
        catch (Exception e) {
            log.errorAccessingTokenState(tokenId, e);
        }
        return expiration;
    }

    @Override
    protected boolean isUnknown(String tokenId) {
        boolean isUnknown = false;
        try {
            isUnknown = this.aliasService.getPasswordFromAliasForCluster("__gateway", tokenId) == null;
        }
        catch (AliasServiceException e) {
            log.errorAccessingTokenState(tokenId, (Exception)((Object)e));
        }
        return isUnknown;
    }

    @Override
    protected void removeToken(String tokenId) throws UnknownTokenException {
        this.validateToken(tokenId);
        try {
            this.aliasService.removeAliasForCluster("__gateway", tokenId);
            this.aliasService.removeAliasForCluster("__gateway", tokenId + TOKEN_MAX_LIFETIME_POSTFIX);
            log.removedTokenState(tokenId);
        }
        catch (AliasServiceException e) {
            log.failedToRemoveTokenState(tokenId, (Exception)((Object)e));
        }
    }

    @Override
    protected void updateExpiration(String tokenId, long expiration) {
        try {
            this.aliasService.removeAliasForCluster("__gateway", tokenId);
            this.aliasService.addAliasForCluster("__gateway", tokenId, String.valueOf(expiration));
        }
        catch (AliasServiceException e) {
            log.failedToUpdateTokenExpiration(tokenId, (Exception)((Object)e));
        }
    }

    @Override
    protected List<String> getTokens() {
        List<Object> allAliases = new ArrayList();
        try {
            allAliases = this.aliasService.getAliasesForCluster("__gateway");
            allAliases = allAliases.stream().filter(a -> a.contains(TOKEN_MAX_LIFETIME_POSTFIX)).map(a -> a.substring(0, a.indexOf(TOKEN_MAX_LIFETIME_POSTFIX))).collect(Collectors.toList());
        }
        catch (AliasServiceException e) {
            log.errorEvictingTokens((Exception)((Object)e));
        }
        return allAliases;
    }
}

