/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.io;

import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.io.FileDescriptor;
import java.io.IOException;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.io.nativeio.NativeIO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public class ReadaheadPool {
    static final Logger LOG = LoggerFactory.getLogger(ReadaheadPool.class);
    private static final int POOL_SIZE = 4;
    private static final int MAX_POOL_SIZE = 16;
    private static final int CAPACITY = 1024;
    private final ThreadPoolExecutor pool = new ThreadPoolExecutor(4, 16, 3L, TimeUnit.SECONDS, new ArrayBlockingQueue<Runnable>(1024));
    private static ReadaheadPool instance;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ReadaheadPool getInstance() {
        Class<ReadaheadPool> clazz = ReadaheadPool.class;
        synchronized (ReadaheadPool.class) {
            if (instance == null && NativeIO.isAvailable()) {
                instance = new ReadaheadPool();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    private ReadaheadPool() {
        this.pool.setRejectedExecutionHandler(new ThreadPoolExecutor.DiscardOldestPolicy());
        this.pool.setThreadFactory(new ThreadFactoryBuilder().setDaemon(true).setNameFormat("Readahead Thread #%d").build());
    }

    public ReadaheadRequest readaheadStream(String identifier, FileDescriptor fd, long curPos, long readaheadLength, long maxOffsetToRead, ReadaheadRequest lastReadahead) {
        long nextOffset;
        Preconditions.checkArgument((curPos <= maxOffsetToRead ? 1 : 0) != 0, (String)"Readahead position %s higher than maxOffsetToRead %s", (long)curPos, (long)maxOffsetToRead);
        if (readaheadLength <= 0L) {
            return null;
        }
        long lastOffset = Long.MIN_VALUE;
        if (lastReadahead != null) {
            lastOffset = lastReadahead.getOffset();
        }
        if (curPos >= (nextOffset = lastOffset + readaheadLength / 2L)) {
            long length;
            if (lastReadahead != null) {
                lastReadahead.cancel();
                lastReadahead = null;
            }
            if ((length = Math.min(readaheadLength, maxOffsetToRead - curPos)) <= 0L) {
                return null;
            }
            return this.submitReadahead(identifier, fd, curPos, length);
        }
        return lastReadahead;
    }

    public ReadaheadRequest submitReadahead(String identifier, FileDescriptor fd, long off, long len) {
        ReadaheadRequestImpl req = new ReadaheadRequestImpl(identifier, fd, off, len);
        this.pool.execute(req);
        if (LOG.isTraceEnabled()) {
            LOG.trace("submit readahead: " + req);
        }
        return req;
    }

    private static class ReadaheadRequestImpl
    implements Runnable,
    ReadaheadRequest {
        private final String identifier;
        private final FileDescriptor fd;
        private final long off;
        private final long len;
        private volatile boolean canceled = false;

        private ReadaheadRequestImpl(String identifier, FileDescriptor fd, long off, long len) {
            this.identifier = identifier;
            this.fd = fd;
            this.off = off;
            this.len = len;
        }

        @Override
        public void run() {
            if (this.canceled) {
                return;
            }
            try {
                if (this.fd.valid()) {
                    NativeIO.POSIX.getCacheManipulator().posixFadviseIfPossible(this.identifier, this.fd, this.off, this.len, NativeIO.POSIX.POSIX_FADV_WILLNEED);
                }
            }
            catch (IOException ioe) {
                if (this.canceled) {
                    return;
                }
                LOG.warn("Failed readahead on " + this.identifier, (Throwable)ioe);
            }
        }

        @Override
        public void cancel() {
            this.canceled = true;
        }

        @Override
        public long getOffset() {
            return this.off;
        }

        @Override
        public long getLength() {
            return this.len;
        }

        public String toString() {
            return "ReadaheadRequestImpl [identifier='" + this.identifier + "', fd=" + this.fd + ", off=" + this.off + ", len=" + this.len + "]";
        }
    }

    public static interface ReadaheadRequest {
        public void cancel();

        public long getOffset();

        public long getLength();
    }
}

