/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.ha.provider.impl;

import java.util.HashMap;
import java.util.Map;
import org.apache.knox.gateway.ha.provider.HaDescriptor;
import org.apache.knox.gateway.ha.provider.HaServiceConfig;
import org.apache.knox.gateway.ha.provider.impl.DefaultHaDescriptor;
import org.apache.knox.gateway.ha.provider.impl.DefaultHaServiceConfig;
import org.apache.knox.gateway.ha.provider.impl.HaServiceConfigConstants;

public abstract class HaDescriptorFactory
implements HaServiceConfigConstants {
    public static HaDescriptor createDescriptor() {
        return new DefaultHaDescriptor();
    }

    public static HaServiceConfig createServiceConfig(String serviceName, String config) {
        Map<String, String> configMap = HaDescriptorFactory.parseHaConfiguration(config);
        String enabledValue = configMap.get("enabled");
        String maxFailoverAttempts = configMap.get("maxFailoverAttempts");
        String failoverSleep = configMap.get("failoverSleep");
        String zookeeperEnsemble = configMap.get("zookeeperEnsemble");
        String zookeeperNamespace = configMap.get("zookeeperNamespace");
        String stickySessionEnabled = configMap.get("enableStickySession");
        String loadBalancingEnabled = configMap.get("enableLoadBalancing");
        String stickySessionCookieName = configMap.get("stickySessionCookieName");
        String noFallbackEnabled = configMap.get("noFallback");
        return HaDescriptorFactory.createServiceConfig(serviceName, enabledValue, maxFailoverAttempts, failoverSleep, zookeeperEnsemble, zookeeperNamespace, loadBalancingEnabled, stickySessionEnabled, stickySessionCookieName, noFallbackEnabled);
    }

    public static HaServiceConfig createServiceConfig(String serviceName, String enabledValue, String maxFailoverAttemptsValue, String failoverSleepValue, String zookeeperEnsemble, String zookeeperNamespace, String loadBalancingEnabledValue, String stickySessionsEnabledValue, String stickySessionCookieNameValue, String noFallbackEnabledValue) {
        boolean enabled = true;
        int maxFailoverAttempts = 3;
        int failoverSleep = 1000;
        boolean stickySessionsEnabled = false;
        boolean loadBalancingEnabled = false;
        boolean noFallbackEnabled = false;
        String stickySessionCookieName = "KNOX_BACKEND";
        if (enabledValue != null && !enabledValue.trim().isEmpty()) {
            enabled = Boolean.parseBoolean(enabledValue);
        }
        if (maxFailoverAttemptsValue != null && !maxFailoverAttemptsValue.trim().isEmpty()) {
            maxFailoverAttempts = Integer.parseInt(maxFailoverAttemptsValue);
        }
        if (failoverSleepValue != null && !failoverSleepValue.trim().isEmpty()) {
            failoverSleep = Integer.parseInt(failoverSleepValue);
        }
        if (stickySessionsEnabledValue != null && !stickySessionsEnabledValue.trim().isEmpty()) {
            stickySessionsEnabled = Boolean.parseBoolean(stickySessionsEnabledValue);
        }
        if (loadBalancingEnabledValue != null && !loadBalancingEnabledValue.trim().isEmpty()) {
            loadBalancingEnabled = Boolean.parseBoolean(loadBalancingEnabledValue);
        }
        if (stickySessionCookieNameValue != null && !stickySessionCookieNameValue.trim().isEmpty()) {
            stickySessionCookieName = stickySessionCookieNameValue;
        }
        if (noFallbackEnabledValue != null && !noFallbackEnabledValue.trim().isEmpty()) {
            noFallbackEnabled = Boolean.parseBoolean(noFallbackEnabledValue);
        }
        DefaultHaServiceConfig serviceConfig = new DefaultHaServiceConfig(serviceName);
        serviceConfig.setEnabled(enabled);
        serviceConfig.setMaxFailoverAttempts(maxFailoverAttempts);
        serviceConfig.setFailoverSleep(failoverSleep);
        serviceConfig.setZookeeperEnsemble(zookeeperEnsemble);
        serviceConfig.setZookeeperNamespace(zookeeperNamespace);
        serviceConfig.setStickySessionEnabled(stickySessionsEnabled);
        serviceConfig.setLoadBalancingEnabled(loadBalancingEnabled);
        serviceConfig.setStickySessionCookieName(stickySessionCookieName);
        serviceConfig.setNoFallbackEnabled(noFallbackEnabled);
        return serviceConfig;
    }

    private static Map<String, String> parseHaConfiguration(String configuration) {
        HashMap<String, String> parameters = new HashMap<String, String>();
        if (configuration != null) {
            String[] pairs;
            for (String pair : pairs = configuration.split(";")) {
                String[] tokens = pair.split("=");
                if (tokens.length != 2) continue;
                parameters.put(tokens[0], tokens[1]);
            }
        }
        return parameters;
    }
}

