/*
 * Decompiled with CFR 0.152.
 */
package org.ldaptive;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.TreeMap;
import org.ldaptive.AbstractLdapBean;
import org.ldaptive.AttributeModification;
import org.ldaptive.AttributeModificationType;
import org.ldaptive.LdapAttribute;
import org.ldaptive.LdapUtils;
import org.ldaptive.SortBehavior;

public class LdapEntry
extends AbstractLdapBean {
    private static final int HASH_CODE_SEED = 331;
    private static final long serialVersionUID = 7819007625501406463L;
    private String entryDn;
    private final Map<String, LdapAttribute> entryAttributes;

    public LdapEntry() {
        this(SortBehavior.getDefaultSortBehavior());
    }

    public LdapEntry(SortBehavior sb) {
        super(sb);
        if (SortBehavior.UNORDERED == sb) {
            this.entryAttributes = new HashMap<String, LdapAttribute>();
        } else if (SortBehavior.ORDERED == sb) {
            this.entryAttributes = new LinkedHashMap<String, LdapAttribute>();
        } else if (SortBehavior.SORTED == sb) {
            this.entryAttributes = new TreeMap<String, LdapAttribute>(String.CASE_INSENSITIVE_ORDER);
        } else {
            throw new IllegalArgumentException("Unknown sort behavior: " + (Object)((Object)sb));
        }
    }

    public LdapEntry(String dn) {
        this();
        this.setDn(dn);
    }

    public LdapEntry(String dn, LdapAttribute ... attr) {
        this();
        this.setDn(dn);
        for (LdapAttribute a : attr) {
            this.addAttribute(a);
        }
    }

    public LdapEntry(String dn, Collection<LdapAttribute> attrs) {
        this();
        this.setDn(dn);
        this.addAttributes(attrs);
    }

    public String getDn() {
        return this.entryDn;
    }

    public void setDn(String dn) {
        this.entryDn = dn;
    }

    public Collection<LdapAttribute> getAttributes() {
        return this.entryAttributes.values();
    }

    public LdapAttribute getAttribute() {
        if (this.entryAttributes.isEmpty()) {
            return null;
        }
        return this.entryAttributes.values().iterator().next();
    }

    public LdapAttribute getAttribute(String name) {
        if (name != null) {
            return this.entryAttributes.get(name.toLowerCase());
        }
        return null;
    }

    public String[] getAttributeNames() {
        String[] names = new String[this.entryAttributes.size()];
        int i = 0;
        for (LdapAttribute la : this.entryAttributes.values()) {
            names[i++] = la.getName();
        }
        return names;
    }

    public void addAttribute(LdapAttribute ... attr) {
        for (LdapAttribute a : attr) {
            this.entryAttributes.put(a.getName().toLowerCase(), a);
        }
    }

    public void addAttributes(Collection<LdapAttribute> attrs) {
        for (LdapAttribute la : attrs) {
            this.addAttribute(la);
        }
    }

    public void removeAttribute(LdapAttribute ... attr) {
        for (LdapAttribute a : attr) {
            this.entryAttributes.remove(a.getName().toLowerCase());
        }
    }

    public void removeAttribute(String name) {
        this.entryAttributes.remove(name.toLowerCase());
    }

    public void removeAttributes(Collection<LdapAttribute> attrs) {
        for (LdapAttribute la : attrs) {
            this.removeAttribute(la);
        }
    }

    public int size() {
        return this.entryAttributes.size();
    }

    public void clear() {
        this.entryAttributes.clear();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            LdapEntry v = (LdapEntry)o;
            return LdapUtils.areEqual(this.entryDn != null ? this.entryDn.toLowerCase() : null, v.entryDn != null ? v.entryDn.toLowerCase() : null) && LdapUtils.areEqual(this.entryAttributes, v.entryAttributes);
        }
        return false;
    }

    public int hashCode() {
        return LdapUtils.computeHashCode(331, this.entryDn != null ? this.entryDn.toLowerCase() : null, this.entryAttributes.values());
    }

    public String toString() {
        return String.format("[dn=%s%s]", this.entryDn, this.entryAttributes.values());
    }

    public static AttributeModification[] computeModifications(LdapEntry source, LdapEntry target) {
        AttributeModification mod;
        ArrayList<AttributeModification> mods = new ArrayList<AttributeModification>();
        for (LdapAttribute sourceAttr : source.getAttributes()) {
            LdapAttribute targetAttr = target.getAttribute(sourceAttr.getName());
            if (targetAttr == null) {
                mod = new AttributeModification(AttributeModificationType.ADD, sourceAttr);
                mods.add(mod);
                continue;
            }
            if (targetAttr.equals(sourceAttr)) continue;
            mod = new AttributeModification(AttributeModificationType.REPLACE, sourceAttr);
            mods.add(mod);
        }
        for (LdapAttribute targetAttr : target.getAttributes()) {
            LdapAttribute sourceAttr = source.getAttribute(targetAttr.getName());
            if (sourceAttr != null) continue;
            mod = new AttributeModification(AttributeModificationType.REMOVE, targetAttr);
            mods.add(mod);
        }
        return mods.toArray(new AttributeModification[mods.size()]);
    }
}

