/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.core.profile;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.pac4j.core.authorization.authorizer.Authorizer;
import org.pac4j.core.authorization.authorizer.IsAuthenticatedAuthorizer;
import org.pac4j.core.client.Client;
import org.pac4j.core.config.Config;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.context.session.SessionStore;
import org.pac4j.core.exception.TechnicalException;
import org.pac4j.core.exception.http.HttpAction;
import org.pac4j.core.profile.ProfileHelper;
import org.pac4j.core.profile.UserProfile;
import org.pac4j.core.util.CommonHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProfileManager<U extends UserProfile> {
    private final Authorizer<U> IS_AUTHENTICATED_AUTHORIZER = new IsAuthenticatedAuthorizer();
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    protected final WebContext context;
    protected final SessionStore sessionStore;
    protected Config config;

    public ProfileManager(WebContext context) {
        CommonHelper.assertNotNull("context", context);
        this.context = context;
        this.sessionStore = context.getSessionStore();
    }

    public ProfileManager(WebContext context, SessionStore sessionStore) {
        CommonHelper.assertNotNull("context", context);
        CommonHelper.assertNotNull("sessionStore", sessionStore);
        this.context = context;
        this.sessionStore = sessionStore;
    }

    public Optional<U> get(boolean readFromSession) {
        LinkedHashMap<String, U> allProfiles = this.retrieveAll(readFromSession);
        return ProfileHelper.flatIntoOneProfile(allProfiles.values());
    }

    public Optional<U> getLikeDefaultSecurityLogic(boolean readFromSessionDefault) {
        return this.get(this.retrieveLoadProfilesFromSession(readFromSessionDefault));
    }

    protected boolean retrieveLoadProfilesFromSession(boolean readFromSessionDefault) {
        Optional loadProfilesFromSession = this.context.getRequestAttribute("pac4jLoadProfilesFromSession");
        if (loadProfilesFromSession.isPresent()) {
            return (Boolean)loadProfilesFromSession.get();
        }
        return readFromSessionDefault;
    }

    public List<U> getAll(boolean readFromSession) {
        LinkedHashMap<String, U> profiles = this.retrieveAll(readFromSession);
        return ProfileHelper.flatIntoAProfileList(profiles);
    }

    public List<U> getAllLikeDefaultSecurityLogic(boolean readFromSessionDefault) {
        return this.getAll(this.retrieveLoadProfilesFromSession(readFromSessionDefault));
    }

    protected LinkedHashMap<String, U> retrieveAll(boolean readFromSession) {
        LinkedHashMap profiles = new LinkedHashMap();
        this.context.getRequestAttribute("pac4jUserProfiles").ifPresent(requestAttribute -> profiles.putAll((Map)requestAttribute));
        if (readFromSession) {
            this.sessionStore.get(this.context, "pac4jUserProfiles").ifPresent(sessionAttribute -> profiles.putAll((Map)sessionAttribute));
        }
        this.removeOrRenewExpiredProfiles(profiles, readFromSession);
        return profiles;
    }

    protected void removeOrRenewExpiredProfiles(LinkedHashMap<String, U> profiles, boolean readFromSession) {
        boolean profilesUpdated = false;
        for (Map.Entry<String, U> entry : profiles.entrySet()) {
            Optional<Client> client;
            String key = entry.getKey();
            UserProfile profile = (UserProfile)entry.getValue();
            if (!profile.isExpired()) continue;
            profilesUpdated = true;
            profiles.remove(key);
            if (this.config == null || profile.getClientName() == null || !(client = this.config.getClients().findClient(profile.getClientName())).isPresent()) continue;
            try {
                Optional<UserProfile> newProfile = client.get().renewUserProfile(profile, this.context);
                if (!newProfile.isPresent()) continue;
                profiles.put(key, newProfile.get());
            }
            catch (RuntimeException e) {
                this.logger.error("Unable to renew the user profile for key: {}", (Object)key, (Object)e);
            }
        }
        if (profilesUpdated) {
            this.saveAll(profiles, readFromSession);
        }
    }

    public void remove(boolean removeFromSession) {
        if (removeFromSession) {
            this.sessionStore.set(this.context, "pac4jUserProfiles", new LinkedHashMap());
        }
        this.context.setRequestAttribute("pac4jUserProfiles", new LinkedHashMap());
    }

    public void save(boolean saveInSession, U profile, boolean multiProfile) {
        LinkedHashMap<String, Object> profiles;
        String clientName = this.retrieveClientName(profile);
        if (multiProfile) {
            profiles = this.retrieveAll(saveInSession);
            profiles.remove(clientName);
        } else {
            profiles = new LinkedHashMap();
        }
        profiles.put(clientName, profile);
        this.saveAll(profiles, saveInSession);
    }

    protected String retrieveClientName(U profile) {
        String clientName = profile.getClientName();
        if (clientName == null) {
            clientName = "DEFAULT";
        }
        return clientName;
    }

    protected void saveAll(LinkedHashMap<String, U> profiles, boolean saveInSession) {
        if (saveInSession) {
            this.sessionStore.set(this.context, "pac4jUserProfiles", profiles);
        }
        this.context.setRequestAttribute("pac4jUserProfiles", profiles);
    }

    public void logout() {
        this.remove(true);
    }

    public boolean isAuthenticated() {
        try {
            return this.IS_AUTHENTICATED_AUTHORIZER.isAuthorized(null, this.getAll(true));
        }
        catch (HttpAction e) {
            throw new TechnicalException(e);
        }
    }

    public Config getConfig() {
        return this.config;
    }

    public void setConfig(Config config) {
        this.config = config;
    }
}

