/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ehcache.util.ratestatistics;

import java.util.concurrent.TimeUnit;
import net.sf.ehcache.util.ratestatistics.AbstractRateStatistic;

public class UnlockedRateStatistic
extends AbstractRateStatistic {
    private volatile long count;
    private volatile long rateSampleTime = System.nanoTime();
    private volatile float rateSample = 0.0f;
    private volatile long sampleRateMask;
    private volatile long previousSample;

    public UnlockedRateStatistic(long averagePeriod, TimeUnit unit) {
        super(averagePeriod, unit);
    }

    @Override
    public void event() {
        long previous;
        long now;
        long value;
        if (((value = ++this.count) & this.sampleRateMask) == 0L && (now = System.nanoTime()) != (previous = this.rateSampleTime) && value > this.previousSample) {
            this.rateSampleTime = now;
            float nowRate = (float)(value - this.previousSample) / (float)(now - previous);
            this.previousSample = value;
            this.rateSample = this.iterateMovingAverage(nowRate, now, this.rateSample, previous);
            long suggestedSampleRateMask = Long.highestOneBit(Math.max(1L, (long)((float)this.getRateAveragePeriod() * this.rateSample))) - 1L;
            if (suggestedSampleRateMask != this.sampleRateMask) {
                this.sampleRateMask = suggestedSampleRateMask;
            }
        }
    }

    @Override
    public long getCount() {
        return this.count;
    }

    @Override
    public float getRate() {
        long then = this.rateSampleTime;
        long lastSample = this.previousSample;
        float thenAverage = this.rateSample;
        long now = System.nanoTime();
        if (now == then) {
            return thenAverage;
        }
        float nowValue = (float)(this.count - lastSample) / (float)(now - then);
        float rate = this.iterateMovingAverage(nowValue, now, thenAverage, then) * (float)TimeUnit.SECONDS.toNanos(1L);
        if (Float.isNaN(rate)) {
            if (Float.isNaN(thenAverage)) {
                return 0.0f;
            }
            return thenAverage;
        }
        return rate;
    }
}

