/*
 * Decompiled with CFR 0.152.
 */
package org.ldaptive.concurrent;

import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.ldaptive.Connection;
import org.ldaptive.LdapException;
import org.ldaptive.Operation;
import org.ldaptive.Request;
import org.ldaptive.Response;
import org.ldaptive.SearchFilter;
import org.ldaptive.SearchOperation;
import org.ldaptive.SearchRequest;
import org.ldaptive.SearchResult;
import org.ldaptive.concurrent.AbstractAggregateSearchExecutor;
import org.ldaptive.handler.SearchEntryHandler;
import org.ldaptive.pool.PooledConnectionFactory;

public class AggregatePooledSearchExecutor
extends AbstractAggregateSearchExecutor<PooledConnectionFactory> {
    public AggregatePooledSearchExecutor() {
        this(Executors.newCachedThreadPool());
    }

    public AggregatePooledSearchExecutor(ExecutorService es) {
        super(es);
    }

    /*
     * WARNING - void declaration
     */
    public Collection<Response<SearchResult>> search(PooledConnectionFactory[] factories, SearchFilter[] filters, String[] attrs, SearchEntryHandler ... handlers) throws LdapException {
        void var9_11;
        ExecutorCompletionService<Response<SearchResult>> searches = new ExecutorCompletionService<Response<SearchResult>>(this.getExecutorService());
        ArrayList<Future<Response<SearchResult>>> futures = new ArrayList<Future<Response<SearchResult>>>(factories.length * filters.length);
        PooledConnectionFactory[] arr$ = factories;
        int len$ = arr$.length;
        boolean bl = false;
        while (var9_11 < len$) {
            PooledConnectionFactory factory = arr$[var9_11];
            for (SearchFilter filter : filters) {
                SearchRequest sr = AggregatePooledSearchExecutor.newSearchRequest(this);
                if (filter != null) {
                    sr.setSearchFilter(filter);
                }
                if (attrs != null) {
                    sr.setReturnAttributes(attrs);
                }
                if (handlers != null) {
                    sr.setSearchEntryHandlers(handlers);
                }
                Connection conn = factory.getConnection();
                SearchOperation op = this.createSearchOperation(conn);
                futures.add(searches.submit(AggregatePooledSearchExecutor.createCallable(conn, op, sr)));
            }
            ++var9_11;
        }
        ArrayList<Response<SearchResult>> responses = new ArrayList<Response<SearchResult>>(factories.length * filters.length);
        for (Future future : futures) {
            try {
                responses.add((Response<SearchResult>)future.get());
            }
            catch (ExecutionException e) {
                this.logger.debug("ExecutionException thrown, ignoring", (Throwable)e);
            }
            catch (InterruptedException e) {
                this.logger.warn("InterruptedException thrown, ignoring", (Throwable)e);
            }
        }
        return responses;
    }

    protected static <Q extends Request, S> Callable<Response<S>> createCallable(final Connection conn, final Operation<Q, S> operation, final Q request) {
        return new Callable<Response<S>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Response<S> call() throws LdapException {
                try {
                    conn.open();
                    Response response = operation.execute(request);
                    return response;
                }
                finally {
                    conn.close();
                }
            }
        };
    }
}

