/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.util;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ser.FilterProvider;
import java.io.IOException;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.knox.gateway.i18n.GatewayUtilCommonMessages;
import org.apache.knox.gateway.i18n.messages.MessagesFactory;

public class JsonUtils {
    private static final GatewayUtilCommonMessages LOG = (GatewayUtilCommonMessages)MessagesFactory.get(GatewayUtilCommonMessages.class);

    public static String renderAsJsonString(Map<String, Object> map) {
        String json = null;
        ObjectMapper mapper = new ObjectMapper();
        try {
            json = mapper.writeValueAsString(map);
        }
        catch (JsonProcessingException e) {
            LOG.failedToSerializeMapToJSON(map, (Exception)((Object)e));
        }
        return json;
    }

    public static String renderAsJsonString(Object obj) {
        return JsonUtils.renderAsJsonString(obj, null, null);
    }

    public static String renderAsJsonString(Object obj, FilterProvider filterProvider, DateFormat dateFormat) {
        String json = null;
        ObjectMapper mapper = new ObjectMapper();
        if (filterProvider != null) {
            mapper.setFilterProvider(filterProvider);
        }
        if (dateFormat != null) {
            mapper.setDateFormat(dateFormat);
        }
        try {
            json = mapper.writerWithDefaultPrettyPrinter().writeValueAsString(obj);
        }
        catch (JsonProcessingException e) {
            LOG.failedToSerializeObjectToJSON(obj, (Exception)((Object)e));
        }
        return json;
    }

    public static Object getObjectFromJsonString(String json) {
        Map obj = null;
        JsonFactory factory = new JsonFactory();
        ObjectMapper mapper = new ObjectMapper(factory);
        TypeReference<Map<String, Object>> typeRef = new TypeReference<Map<String, Object>>(){};
        try {
            obj = (Map)mapper.readValue(json, (TypeReference)typeRef);
        }
        catch (IOException e) {
            LOG.failedToGetMapFromJsonString(json, e);
        }
        return obj;
    }

    public static Map<String, String> getMapFromJsonString(String json) {
        Map map = null;
        JsonFactory factory = new JsonFactory();
        ObjectMapper mapper = new ObjectMapper(factory);
        TypeReference<HashMap<String, String>> typeRef = new TypeReference<HashMap<String, String>>(){};
        try {
            map = (Map)mapper.readValue(json, (TypeReference)typeRef);
        }
        catch (IOException e) {
            LOG.failedToGetMapFromJsonString(json, e);
        }
        return map;
    }

    public static Map<String, HashMap<String, ArrayList<HashMap<String, String>>>> getFileStatusesAsMap(String json) {
        Map map = null;
        JsonFactory factory = new JsonFactory();
        ObjectMapper mapper = new ObjectMapper(factory);
        TypeReference<HashMap<String, HashMap<String, ArrayList<HashMap<String, String>>>>> typeRef = new TypeReference<HashMap<String, HashMap<String, ArrayList<HashMap<String, String>>>>>(){};
        try {
            map = (Map)mapper.readValue(json, (TypeReference)typeRef);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return map;
    }
}

