/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.profile.action.impl;

import com.google.common.base.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullAfterInit;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.component.InitializableComponent;
import org.opensaml.messaging.context.BaseContext;
import org.opensaml.profile.action.AbstractProfileAction;
import org.opensaml.profile.context.MetricContext;
import org.opensaml.profile.context.ProfileRequestContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PopulateMetricContext
extends AbstractProfileAction {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(PopulateMetricContext.class);
    @NonnullAfterInit
    private Function<ProfileRequestContext, Boolean> metricStrategy;

    public void setMetricStrategy(@Nullable Function<ProfileRequestContext, Boolean> strategy) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.metricStrategy = strategy;
    }

    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (this.metricStrategy == null) {
            this.metricStrategy = new NullFunction();
        }
    }

    protected void doExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        MetricContext metricCtx = new MetricContext();
        profileRequestContext.addSubcontext((BaseContext)metricCtx, true);
        if (!((Boolean)this.metricStrategy.apply((Object)profileRequestContext)).booleanValue()) {
            this.log.warn("{} Configuration of metric mappings by supplied strategy function failed", (Object)this.getLogPrefix());
        }
    }

    private class NullFunction
    implements Function<ProfileRequestContext, Boolean> {
        private NullFunction() {
        }

        public Boolean apply(ProfileRequestContext input) {
            input.removeSubcontext(MetricContext.class);
            return true;
        }
    }
}

