/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.jdbc;

import java.io.IOException;
import java.io.StringWriter;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.TimeZone;
import org.apache.kylin.jdbc.Driver;
import org.apache.kylin.jdbc.IRemoteClient;
import org.apache.kylin.jdbc.KylinConnection;
import org.apache.kylin.jdbc.KylinPreparedStatement;
import org.apache.kylin.jdbc.shaded.org.apache.calcite.avatica.AvaticaParameter;
import org.apache.kylin.jdbc.shaded.org.apache.calcite.avatica.AvaticaResultSet;
import org.apache.kylin.jdbc.shaded.org.apache.calcite.avatica.AvaticaStatement;
import org.apache.kylin.jdbc.shaded.org.apache.calcite.avatica.Meta;
import org.apache.kylin.jdbc.shaded.org.apache.calcite.avatica.MetaImpl;
import org.apache.kylin.jdbc.shaded.org.apache.calcite.avatica.QueryState;

public class KylinResultSet
extends AvaticaResultSet {
    public KylinResultSet(AvaticaStatement statement, QueryState state, Meta.Signature signature, ResultSetMetaData resultSetMetaData, TimeZone timeZone, Meta.Frame firstFrame) throws SQLException {
        super(statement, state, signature, resultSetMetaData, timeZone, firstFrame);
    }

    @Override
    protected AvaticaResultSet execute() throws SQLException {
        IRemoteClient.QueryResult result;
        if (this.firstFrame != null) {
            return super.execute();
        }
        String sql = this.signature.sql;
        List<AvaticaParameter> params = this.signature.parameters;
        List<Object> paramValues = null;
        if (!(this.statement instanceof KylinPreparedStatement)) {
            params = null;
        } else if (params != null && !params.isEmpty()) {
            paramValues = ((KylinPreparedStatement)this.statement).getParameterJDBCValues();
        }
        KylinConnection connection = (KylinConnection)this.statement.connection;
        IRemoteClient client = connection.getRemoteClient();
        HashMap<String, String> queryToggles = new HashMap<String, String>();
        int maxRows = this.statement.getMaxRows();
        queryToggles.put("ATTR_STATEMENT_MAX_ROWS", String.valueOf(maxRows));
        this.addServerProps(queryToggles, connection);
        try {
            result = client.executeQuery(sql, paramValues, queryToggles);
        }
        catch (IOException e) {
            throw new SQLException(e);
        }
        this.columnMetaDataList.clear();
        this.columnMetaDataList.addAll(result.columnMeta);
        this.cursor = MetaImpl.createCursor(this.signature.cursorFactory, result.iterable);
        return super.execute2(this.cursor, this.columnMetaDataList);
    }

    private void addServerProps(Map<String, String> queryToggles, KylinConnection connection) {
        Properties connProps = connection.getConnectionProperties();
        Properties props = new Properties();
        for (String key : connProps.stringPropertyNames()) {
            if (!Driver.CLIENT_CALCITE_PROP_NAMES.contains(key)) continue;
            props.put(key, connProps.getProperty(key));
        }
        if (props.isEmpty()) {
            return;
        }
        StringWriter writer = new StringWriter();
        try {
            props.store(writer, "");
        }
        catch (IOException ignored) {
            return;
        }
        queryToggles.put("JDBC_CLIENT_CALCITE_PROPS", writer.toString());
    }
}

