/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.common.util;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.PrintStream;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.util.BytesUtil;
import org.apache.kylin.shaded.com.google.common.collect.Lists;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Dictionary<T>
implements Serializable {
    private static final Logger logger = LoggerFactory.getLogger(Dictionary.class);
    private static final long serialVersionUID = 1L;
    protected static final int[] NULL_ID = new int[]{0, 255, 65535, 0xFFFFFF, -1};
    protected int cacheHitCount = 0;
    protected int cacheMissCount = 0;

    public abstract int getMinId();

    public abstract int getMaxId();

    public int getSize() {
        return this.getMaxId() - this.getMinId() + 1;
    }

    public abstract int getSizeOfId();

    public abstract int getSizeOfValue();

    public abstract boolean contains(Dictionary<?> var1);

    public final int getIdFromValue(T value) throws IllegalArgumentException {
        return this.getIdFromValue(value, 0);
    }

    public final int getIdFromValue(T value, int roundingFlag) throws IllegalArgumentException {
        if (this.isNullObjectForm(value)) {
            return this.nullId();
        }
        int id = this.getIdFromValueImpl(value, roundingFlag);
        if (id == -1) {
            throw new IllegalArgumentException("Value : " + value + " not exists");
        }
        return id;
    }

    public final boolean containsValue(T value) throws IllegalArgumentException {
        if (this.isNullObjectForm(value)) {
            return true;
        }
        try {
            this.getIdFromValueImpl(value, 0);
        }
        catch (IllegalArgumentException e) {
            return false;
        }
        return true;
    }

    protected boolean isNullObjectForm(T value) {
        return value == null;
    }

    protected abstract int getIdFromValueImpl(T var1, int var2);

    public final T getValueFromId(int id) throws IllegalArgumentException {
        if (this.isNullId(id)) {
            return null;
        }
        return this.getValueFromIdImpl(id);
    }

    public final byte[] getValueByteFromId(int id) throws IllegalArgumentException {
        if (this.isNullId(id)) {
            return null;
        }
        return this.getValueBytesFromIdImpl(id);
    }

    protected byte[] getValueBytesFromIdImpl(int id) {
        throw new UnsupportedOperationException();
    }

    public void printlnStatistics() {
        logger.info("cache hit count: " + this.cacheHitCount);
        logger.info("cache miss count: " + this.cacheMissCount);
        logger.info("cache hit percent: " + (double)this.cacheHitCount * 1.0 / (double)(this.cacheMissCount + this.cacheHitCount));
        this.cacheHitCount = 0;
        this.cacheMissCount = 0;
    }

    protected abstract T getValueFromIdImpl(int var1);

    public abstract void dump(PrintStream var1);

    public List<T> enumeratorValues() {
        ArrayList<T> ret = Lists.newArrayListWithExpectedSize(this.getSize());
        for (int i = this.getMinId(); i <= this.getMaxId(); ++i) {
            ret.add(this.getValueFromId(i));
        }
        return ret;
    }

    public int nullId() {
        return NULL_ID[this.getSizeOfId()];
    }

    public boolean isNullId(int id) {
        int nullId = NULL_ID[this.getSizeOfId()];
        return (nullId & id) == nullId;
    }

    public Dictionary copyToAnotherMeta(KylinConfig srcConfig, KylinConfig dstConfig) throws IOException {
        return this;
    }

    public static String dictIdToString(byte[] idBytes, int offset, int length) {
        try {
            return new String(idBytes, offset, length, "ISO-8859-1");
        }
        catch (UnsupportedEncodingException e) {
            return null;
        }
    }

    public static int stringToDictId(String str) {
        try {
            byte[] bytes = str.getBytes("ISO-8859-1");
            return BytesUtil.readUnsigned(bytes, 0, bytes.length);
        }
        catch (UnsupportedEncodingException e) {
            return 0;
        }
    }

    public abstract void write(DataOutput var1) throws IOException;

    public abstract void readFields(DataInput var1) throws IOException;
}

