/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.dict;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.lang.ref.SoftReference;
import java.util.concurrent.TimeUnit;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.util.Dictionary;
import org.apache.kylin.dict.BytesConverter;

public abstract class CacheDictionary<T>
extends Dictionary<T> {
    private static final long serialVersionUID = 1L;
    private transient LoadingCache<T, Integer> valueToIdCache;
    private transient SoftReference<byte[][]> idToValueByteCache;
    protected transient int baseId;
    protected BytesConverter<T> bytesConvert;

    CacheDictionary() {
    }

    @Override
    protected final int getIdFromValueImpl(T value, int roundingFlag) {
        try {
            if (this.valueToIdCache != null && roundingFlag == 0) {
                ++this.cacheHitCount;
                return (Integer)this.valueToIdCache.get(value);
            }
        }
        catch (Exception th) {
            throw new IllegalArgumentException("Error to get Id From Value from Cache", th);
        }
        byte[] valueBytes = this.bytesConvert.convertToBytes(value);
        return this.getIdFromValueBytesWithoutCache(valueBytes, 0, valueBytes.length, roundingFlag);
    }

    @Override
    protected final T getValueFromIdImpl(int id) {
        byte[] valueBytes = this.getValueBytesCacheFromIdImpl(id);
        return this.bytesConvert.convertFromBytes(valueBytes, 0, valueBytes.length);
    }

    private byte[] getValueBytesCacheFromIdImpl(int id) {
        byte[][] bytes;
        byte[][] byArray = bytes = this.idToValueByteCache != null ? this.idToValueByteCache.get() : (byte[][])null;
        if (bytes != null) {
            int seq = this.calcSeqNoFromId(id);
            byte[] valueBytes = bytes[seq];
            if (valueBytes != null) {
                ++this.cacheHitCount;
            } else {
                ++this.cacheMissCount;
                valueBytes = this.getValueBytesFromIdWithoutCache(id);
                bytes[seq] = valueBytes;
            }
            return valueBytes;
        }
        return this.getValueBytesFromIdWithoutCache(id);
    }

    @Override
    protected byte[] getValueBytesFromIdImpl(int id) {
        byte[] valueBytes = this.getValueBytesCacheFromIdImpl(id);
        return this.bytesConvert.convertBytesValueFromBytes(valueBytes, 0, valueBytes.length);
    }

    final int calcSeqNoFromId(int id) {
        int seq = id - this.baseId;
        if (seq < 0 || seq >= this.getSize()) {
            throw new IllegalArgumentException("Not a valid ID: " + id);
        }
        return seq;
    }

    public final void enableCache() {
        if (this.valueToIdCache == null) {
            this.valueToIdCache = CacheBuilder.newBuilder().softValues().expireAfterAccess(30L, TimeUnit.MINUTES).maximumSize(KylinConfig.getInstanceFromEnv().getCachedDictionaryMaxEntrySize()).build(new CacheLoader<T, Integer>(){

                public Integer load(T value) {
                    CacheDictionary.this.cacheMissCount++;
                    CacheDictionary.this.cacheHitCount--;
                    byte[] valueBytes = CacheDictionary.this.bytesConvert.convertToBytes(value);
                    return CacheDictionary.this.getIdFromValueBytesWithoutCache(valueBytes, 0, valueBytes.length, 0);
                }
            });
        }
        if (this.idToValueByteCache == null) {
            this.idToValueByteCache = new SoftReference<byte[][]>(new byte[this.getSize()][]);
        }
    }

    public final void disableCache() {
        this.valueToIdCache = null;
        this.idToValueByteCache = null;
    }

    protected abstract byte[] getValueBytesFromIdWithoutCache(int var1);

    protected abstract int getIdFromValueBytesWithoutCache(byte[] var1, int var2, int var3, int var4);
}

