/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.dict;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.IdentityHashMap;
import java.util.LinkedList;
import org.apache.kylin.common.util.BytesUtil;
import org.apache.kylin.dict.BytesConverter;
import org.apache.kylin.dict.TrieDictionary;

public class TrieDictionaryBuilder<T> {
    public static final int _2GB = 2000000000;
    private Node root;
    protected BytesConverter<T> bytesConverter;
    private boolean hasValue = false;
    private CompleteParts completeParts = new CompleteParts();

    public TrieDictionaryBuilder(BytesConverter<T> bytesConverter) {
        this.root = new Node(new byte[0], false);
        this.bytesConverter = bytesConverter;
    }

    public void addValue(T value) {
        this.addValue(this.bytesConverter.convertToBytes(value));
    }

    void addValue(byte[] value) {
        this.addValueR(this.root, value, 0, false);
    }

    void addValue(byte[] value, boolean isSplitValue) {
        this.addValueR(this.root, value, 0, isSplitValue);
    }

    private void addValueR(Node node, byte[] value, int start, boolean isSplitValue) {
        int j;
        this.hasValue = true;
        int i = 0;
        int n = node.part.length;
        int nn = value.length;
        int comp = 0;
        for (j = start; i < n && j < nn && (comp = BytesUtil.compareByteUnsigned(node.part[i], value[j])) == 0; ++i, ++j) {
        }
        if (j == nn) {
            if (i == n) {
                if (!isSplitValue) {
                    node.isEndOfValue = true;
                }
            } else {
                Node c = new Node(BytesUtil.subarray(node.part, i, n), node.isEndOfValue, node.children);
                node.reset(BytesUtil.subarray(node.part, 0, i), !isSplitValue);
                node.children.add(c);
            }
            return;
        }
        if (i < n) {
            Node c1 = new Node(BytesUtil.subarray(node.part, i, n), node.isEndOfValue, node.children);
            Node c2 = new Node(BytesUtil.subarray(value, j, nn), !isSplitValue);
            node.reset(BytesUtil.subarray(node.part, 0, i), false);
            if (comp < 0) {
                node.children.add(c1);
                node.children.add(c2);
            } else {
                node.children.add(c2);
                node.children.add(c1);
            }
            return;
        }
        byte lookfor = value[j];
        int lo = 0;
        int hi = node.children.size() - 1;
        int mid = 0;
        boolean found = false;
        comp = 0;
        while (!found && lo <= hi) {
            mid = lo + (hi - lo) / 2;
            comp = BytesUtil.compareByteUnsigned(lookfor, node.children.get((int)mid).part[0]);
            if (comp < 0) {
                hi = mid - 1;
                continue;
            }
            if (comp > 0) {
                lo = mid + 1;
                continue;
            }
            found = true;
        }
        if (found) {
            this.addValueR(node.children.get(mid), value, j, isSplitValue);
        } else {
            Node c = new Node(BytesUtil.subarray(value, j, nn), !isSplitValue);
            node.children.add(comp <= 0 ? mid : mid + 1, c);
        }
    }

    public void traverse(Visitor visitor) {
        this.traverseR(this.root, visitor, 0);
    }

    private void traverseR(Node node, Visitor visitor, int level) {
        visitor.visit(node, level);
        for (Node c : node.children) {
            this.traverseR(c, visitor, level + 1);
        }
    }

    public void traversePostOrder(Visitor visitor) {
        this.traversePostOrderR(this.root, visitor, 0);
    }

    private void traversePostOrderR(Node node, Visitor visitor, int level) {
        for (Node c : node.children) {
            this.traversePostOrderR(c, visitor, level + 1);
        }
        visitor.visit(node, level);
    }

    public boolean isHasValue() {
        return this.hasValue;
    }

    public Stats stats() {
        long t;
        this.traversePostOrder(new Visitor(){

            @Override
            public void visit(Node n, int level) {
                n.nValuesBeneath = n.isEndOfValue ? 1 : 0;
                for (Node c : n.children) {
                    n.nValuesBeneath += c.nValuesBeneath;
                }
            }
        });
        final Stats s = new Stats();
        final ArrayList lenAtLvl = new ArrayList();
        this.traverse(new Visitor(){

            @Override
            public void visit(Node n, int level) {
                if (n.isEndOfValue) {
                    ++s.nValues;
                }
                s.nValueBytesPlain += n.part.length * n.nValuesBeneath;
                s.nValueBytesCompressed += n.part.length;
                ++s.mbpn_nNodes;
                if (s.mbpn_trieDepth < level + 1) {
                    s.mbpn_trieDepth = level + 1;
                }
                if (n.children.size() > 0) {
                    if (s.mbpn_maxFanOut < n.children.size()) {
                        s.mbpn_maxFanOut = n.children.size();
                    }
                    int childLookups = n.nValuesBeneath - (n.isEndOfValue ? 1 : 0);
                    s.mbpn_nChildLookups += (long)childLookups;
                    s.mbpn_nTotalFanOut += (long)(childLookups * n.children.size());
                }
                if (level < lenAtLvl.size()) {
                    lenAtLvl.set(level, n.part.length);
                } else {
                    lenAtLvl.add(n.part.length);
                }
                int lenSoFar = 0;
                for (int i = 0; i <= level; ++i) {
                    lenSoFar += ((Integer)lenAtLvl.get(i)).intValue();
                }
                if (lenSoFar > s.maxValueLength) {
                    s.maxValueLength = lenSoFar;
                }
            }
        });
        s.obpn_sizeValue = 1;
        s.obpn_sizeNoValuesBeneath = BytesUtil.sizeForValue(s.nValues);
        s.obpn_sizeChildCount = 1;
        s.obpn_sizeChildOffset = 5;
        s.obpn_nNodes = s.nValueBytesCompressed;
        s.obpn_footprint = (long)s.obpn_nNodes * (long)(s.obpn_sizeValue + s.obpn_sizeNoValuesBeneath + s.obpn_sizeChildCount + s.obpn_sizeChildOffset);
        while (BytesUtil.sizeForValue((t = (long)s.obpn_nNodes * (long)(s.obpn_sizeValue + s.obpn_sizeNoValuesBeneath + s.obpn_sizeChildCount + s.obpn_sizeChildOffset - 1)) * 2L) <= s.obpn_sizeChildOffset - 1) {
            --s.obpn_sizeChildOffset;
            s.obpn_footprint = t;
        }
        s.mbpn_sizeValueTotal = s.nValueBytesCompressed;
        s.mbpn_sizeNoValueBytes = 1;
        s.mbpn_sizeNoValueBeneath = BytesUtil.sizeForValue(s.nValues);
        s.mbpn_sizeChildOffset = 5;
        s.mbpn_footprint = (long)s.mbpn_sizeValueTotal + (long)s.mbpn_nNodes * (long)(s.mbpn_sizeNoValueBytes + s.mbpn_sizeNoValueBeneath + s.mbpn_sizeChildOffset);
        while (BytesUtil.sizeForValue((t = (long)s.mbpn_sizeValueTotal + (long)s.mbpn_nNodes * (long)(s.mbpn_sizeNoValueBytes + s.mbpn_sizeNoValueBeneath + s.mbpn_sizeChildOffset - 1)) * 4L) <= s.mbpn_sizeChildOffset - 1) {
            --s.mbpn_sizeChildOffset;
            s.mbpn_footprint = t;
        }
        return s;
    }

    public void print() {
        this.print(System.out);
    }

    public void print(final PrintStream out) {
        this.traverse(new Visitor(){

            @Override
            public void visit(Node n, int level) {
                try {
                    for (int i = 0; i < level; ++i) {
                        out.print("  ");
                    }
                    out.print(new String(n.part, "UTF-8"));
                    out.print(" - ");
                    if (n.nValuesBeneath > 0) {
                        out.print(n.nValuesBeneath);
                    }
                    if (n.isEndOfValue) {
                        out.print("*");
                    }
                    out.print("\n");
                }
                catch (UnsupportedEncodingException e) {
                    e.printStackTrace();
                }
            }
        });
    }

    private void checkOverflowParts(Node node) {
        LinkedList<Node> childrenCopy = new LinkedList<Node>(node.children);
        for (Node child : childrenCopy) {
            if (child.part.length <= 255) continue;
            byte[] first255 = Arrays.copyOf(child.part, 255);
            this.completeParts.append(node.part);
            this.completeParts.append(first255);
            byte[] visited = this.completeParts.retrieve();
            this.addValue(visited, true);
            this.completeParts.withdraw(255);
            this.completeParts.withdraw(node.part.length);
        }
        this.completeParts.append(node.part);
        for (Node child : node.children) {
            this.checkOverflowParts(child);
        }
        this.completeParts.withdraw(node.part.length);
    }

    public TrieDictionary<T> build(int baseId) {
        byte[] trieBytes = this.buildTrieBytes(baseId);
        TrieDictionary r = new TrieDictionary(trieBytes);
        return r;
    }

    protected byte[] buildTrieBytes(int baseId) {
        byte[] head;
        this.checkOverflowParts(this.root);
        Stats stats = this.stats();
        int sizeNoValuesBeneath = stats.mbpn_sizeNoValueBeneath;
        int sizeChildOffset = stats.mbpn_sizeChildOffset;
        if (stats.mbpn_footprint <= 0L) {
            throw new IllegalStateException("Too big dictionary, dictionary cannot be bigger than 2GB");
        }
        if (stats.mbpn_footprint > 2000000000L) {
            throw new RuntimeException("Too big dictionary, dictionary cannot be bigger than 2GB");
        }
        try {
            ByteArrayOutputStream byteBuf = new ByteArrayOutputStream();
            DataOutputStream headOut = new DataOutputStream(byteBuf);
            headOut.write(TrieDictionary.MAGIC);
            headOut.writeShort(0);
            headOut.writeInt((int)stats.mbpn_footprint);
            headOut.write(sizeChildOffset);
            headOut.write(sizeNoValuesBeneath);
            this.positiveShortPreCheck(baseId, "baseId");
            headOut.writeShort(baseId);
            this.positiveShortPreCheck(stats.maxValueLength, "stats.maxValueLength");
            headOut.writeShort(stats.maxValueLength);
            headOut.writeUTF(this.bytesConverter == null ? "" : this.bytesConverter.getClass().getName());
            headOut.close();
            head = byteBuf.toByteArray();
            BytesUtil.writeUnsigned(head.length, head, TrieDictionary.MAGIC_SIZE_I, 2);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        byte[] trieBytes = new byte[(int)stats.mbpn_footprint + head.length];
        System.arraycopy(head, 0, trieBytes, 0, head.length);
        LinkedList<Node> open = new LinkedList<Node>();
        IdentityHashMap<Node, Integer> offsetMap = new IdentityHashMap<Node, Integer>();
        int o = head.length;
        offsetMap.put(this.root, o);
        o = this.build_writeNode(this.root, o, true, sizeNoValuesBeneath, sizeChildOffset, trieBytes);
        if (!this.root.children.isEmpty()) {
            open.addLast(this.root);
        }
        while (!open.isEmpty()) {
            Node parent = (Node)open.removeFirst();
            this.build_overwriteChildOffset((Integer)offsetMap.get(parent), o - head.length, sizeChildOffset, trieBytes);
            for (int i = 0; i < parent.children.size(); ++i) {
                Node c = parent.children.get(i);
                boolean isLastChild = i == parent.children.size() - 1;
                offsetMap.put(c, o);
                o = this.build_writeNode(c, o, isLastChild, sizeNoValuesBeneath, sizeChildOffset, trieBytes);
                if (c.children.isEmpty()) continue;
                open.addLast(c);
            }
        }
        if (o != trieBytes.length) {
            throw new RuntimeException();
        }
        return trieBytes;
    }

    private void positiveShortPreCheck(int i, String fieldName) {
        if (!BytesUtil.isPositiveShort(i)) {
            throw new IllegalStateException(fieldName + " is not positive short, usually caused by too long dict value.");
        }
    }

    private void build_overwriteChildOffset(int parentOffset, int childOffset, int sizeChildOffset, byte[] trieBytes) {
        int flags = trieBytes[parentOffset] & 0xC0;
        BytesUtil.writeUnsigned(childOffset, trieBytes, parentOffset, sizeChildOffset);
        int n = parentOffset;
        trieBytes[n] = (byte)(trieBytes[n] | flags);
    }

    private int build_writeNode(Node n, int offset, boolean isLastChild, int sizeNoValuesBeneath, int sizeChildOffset, byte[] trieBytes) {
        int o = offset;
        if (o > 2000000000) {
            throw new IllegalStateException();
        }
        if (isLastChild) {
            int n2 = o;
            trieBytes[n2] = (byte)(trieBytes[n2] | 0x80);
        }
        if (n.isEndOfValue) {
            int n3 = o;
            trieBytes[n3] = (byte)(trieBytes[n3] | 0x40);
        }
        BytesUtil.writeUnsigned(n.nValuesBeneath, trieBytes, o += sizeChildOffset, sizeNoValuesBeneath);
        o += sizeNoValuesBeneath;
        if (n.part.length > 255) {
            throw new RuntimeException();
        }
        BytesUtil.writeUnsigned(n.part.length, trieBytes, o, 1);
        System.arraycopy(n.part, 0, trieBytes, ++o, n.part.length);
        return o += n.part.length;
    }

    private class CompleteParts {
        byte[] data = new byte[4096];
        int current = 0;

        private CompleteParts() {
        }

        public void append(byte[] part) {
            while (this.current + part.length > this.data.length) {
                this.expand();
            }
            System.arraycopy(part, 0, this.data, this.current, part.length);
            this.current += part.length;
        }

        public void withdraw(int size) {
            this.current -= size;
        }

        public byte[] retrieve() {
            return Arrays.copyOf(this.data, this.current);
        }

        private void expand() {
            byte[] temp = new byte[2 * this.data.length];
            System.arraycopy(this.data, 0, temp, 0, this.data.length);
            this.data = temp;
        }
    }

    public static class Stats {
        public int nValues;
        public int nValueBytesPlain;
        public int nValueBytesCompressed;
        public int maxValueLength;
        public int mbpn_nNodes;
        public int mbpn_trieDepth;
        public int mbpn_maxFanOut;
        public long mbpn_nChildLookups;
        public long mbpn_nTotalFanOut;
        public int mbpn_sizeValueTotal;
        public int mbpn_sizeNoValueBytes;
        public int mbpn_sizeNoValueBeneath;
        public int mbpn_sizeChildOffset;
        public long mbpn_footprint;
        public int obpn_sizeValue;
        public int obpn_sizeNoValuesBeneath;
        public int obpn_sizeChildCount;
        public int obpn_sizeChildOffset;
        public int obpn_nNodes;
        public long obpn_footprint;

        public void print() {
            PrintStream out = System.out;
            out.println("============================================================================");
            out.println("No. values:             " + this.nValues);
            out.println("No. bytes raw:          " + this.nValueBytesPlain);
            out.println("No. bytes in trie:      " + this.nValueBytesCompressed);
            out.println("Longest value length:   " + this.maxValueLength);
            out.println("----------------------------------------------------------------------------");
            out.println("OBPN node size:  " + (this.obpn_sizeValue + this.obpn_sizeNoValuesBeneath + this.obpn_sizeChildCount + this.obpn_sizeChildOffset) + " = " + this.obpn_sizeValue + " + " + this.obpn_sizeNoValuesBeneath + " + " + this.obpn_sizeChildCount + " + " + this.obpn_sizeChildOffset);
            out.println("OBPN no. nodes:  " + this.obpn_nNodes);
            out.println("OBPN trie depth: " + this.maxValueLength);
            out.println("OBPN footprint:  " + this.obpn_footprint + " in bytes");
            out.println("----------------------------------------------------------------------------");
            out.println("MBPN max fan out:       " + this.mbpn_maxFanOut);
            out.println("MBPN no. child lookups: " + this.mbpn_nChildLookups);
            out.println("MBPN total fan out:     " + this.mbpn_nTotalFanOut);
            out.println("MBPN average fan out:   " + (double)this.mbpn_nTotalFanOut / (double)this.mbpn_nChildLookups);
            out.println("MBPN values size total: " + this.mbpn_sizeValueTotal);
            out.println("MBPN node size:         " + (this.mbpn_sizeNoValueBytes + this.mbpn_sizeNoValueBeneath + this.mbpn_sizeChildOffset) + " = " + this.mbpn_sizeNoValueBytes + " + " + this.mbpn_sizeNoValueBeneath + " + " + this.mbpn_sizeChildOffset);
            out.println("MBPN no. nodes:         " + this.mbpn_nNodes);
            out.println("MBPN trie depth:        " + this.mbpn_trieDepth);
            out.println("MBPN footprint:         " + this.mbpn_footprint + " in bytes");
        }
    }

    public static interface Visitor {
        public void visit(Node var1, int var2);
    }

    public static class Node {
        public byte[] part;
        public boolean isEndOfValue;
        public ArrayList<Node> children;
        public int nValuesBeneath;

        Node(byte[] value, boolean isEndOfValue) {
            this.reset(value, isEndOfValue);
        }

        Node(byte[] value, boolean isEndOfValue, ArrayList<Node> children) {
            this.reset(value, isEndOfValue, children);
        }

        void reset(byte[] value, boolean isEndOfValue) {
            this.reset(value, isEndOfValue, new ArrayList<Node>());
        }

        void reset(byte[] value, boolean isEndOfValue, ArrayList<Node> children) {
            this.part = value;
            this.isEndOfValue = isEndOfValue;
            this.children = children;
        }
    }
}

