/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.engine.mr.steps;

import java.io.IOException;
import org.apache.hadoop.mapreduce.MapContext;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.kylin.cube.inmemcubing.ICuboidWriter;
import org.apache.kylin.cube.inmemcubing.InputConverterUnit;
import org.apache.kylin.cube.inmemcubing.InputConverterUnitForRawData;
import org.apache.kylin.engine.mr.ByteArrayWritable;
import org.apache.kylin.engine.mr.IMRInput;
import org.apache.kylin.engine.mr.MRUtil;
import org.apache.kylin.engine.mr.steps.InMemCuboidMapperBase;
import org.apache.kylin.engine.mr.steps.MapContextGTRecordWriter;
import org.apache.kylin.shaded.com.google.common.base.Preconditions;

public class InMemCuboidMapper<KEYIN>
extends InMemCuboidMapperBase<KEYIN, Object, ByteArrayWritable, ByteArrayWritable, String[]> {
    private IMRInput.IMRTableInputFormat flatTableInputFormat;

    @Override
    protected void doSetup(Mapper.Context context) throws IOException {
        super.doSetup(context);
        this.flatTableInputFormat = MRUtil.getBatchCubingInputSide(this.cubeSegment).getFlatTableInputFormat();
    }

    @Override
    protected InputConverterUnit<String[]> getInputConverterUnit(Mapper.Context context) {
        Preconditions.checkNotNull(this.cubeDesc);
        Preconditions.checkNotNull(this.dictionaryMap);
        return new InputConverterUnitForRawData(this.cubeDesc, this.flatDesc, this.dictionaryMap);
    }

    @Override
    protected String[] getRecordFromKeyValue(KEYIN key, Object value) {
        return this.flatTableInputFormat.parseMapperInput(value).iterator().next();
    }

    @Override
    protected ICuboidWriter getCuboidWriter(Mapper.Context context) {
        return new MapContextGTRecordWriter((MapContext<?, ?, ByteArrayWritable, ByteArrayWritable>)context, this.cubeDesc, this.cubeSegment);
    }
}

