/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.metadata.datatype;

import java.nio.ByteBuffer;
import java.util.Locale;
import org.apache.kylin.metadata.datatype.DataType;
import org.apache.kylin.metadata.datatype.DataTypeSerializer;
import org.apache.kylin.tool.shaded.org.apache.commons.lang.ArrayUtils;
import org.apache.kylin.tool.shaded.org.apache.commons.lang.BooleanUtils;

public class BooleanSerializer
extends DataTypeSerializer<Long> {
    public static final String[] TRUE_VALUE_SET = new String[]{"true", "t", "on", "yes"};

    public BooleanSerializer(DataType type) {
    }

    @Override
    public void serialize(Long value, ByteBuffer out) {
        out.putLong(value);
    }

    @Override
    public Long deserialize(ByteBuffer in) {
        return in.getLong();
    }

    @Override
    public int peekLength(ByteBuffer in) {
        return 8;
    }

    @Override
    public int maxLength() {
        return 8;
    }

    @Override
    public int getStorageBytesEstimate() {
        return 8;
    }

    @Override
    public Long valueOf(String str) {
        if (str == null) {
            return 0L;
        }
        return BooleanUtils.toInteger(ArrayUtils.contains(TRUE_VALUE_SET, str.toLowerCase(Locale.ROOT)));
    }
}

